package com.digiwin.athena.semc.mq.strategy.handler;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.semc.common.enums.MQMessageTypeEnum;
import com.digiwin.athena.semc.mq.dto.MQMessageDTO;
import com.digiwin.athena.semc.mq.dto.NewsCancelFavoriteMessageDTO;
import com.digiwin.athena.semc.mq.strategy.WorkCommonMessageStrategy;
import com.digiwin.athena.semc.service.news.NewsAnnouncementFavoriteService;

import org.springframework.stereotype.Service;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Service
@Slf4j
@RequiredArgsConstructor
public class NewsCancelFavoriteMQHandler implements WorkCommonMessageStrategy {

    private final NewsAnnouncementFavoriteService newsAnnouncementFavoriteService;

    @Override
    public MQMessageTypeEnum getType() {
        return MQMessageTypeEnum.NEWS_CANCEL_FAVORITE;
    }

    @Override
    public boolean doHandler(MQMessageDTO messageDTO) {
        newsAnnouncementFavoriteService.handlerCancelFavoriteNews(JSON.parseObject(messageDTO.getMessage(), NewsCancelFavoriteMessageDTO.class));
        return true;
    }
}
