package com.digiwin.athena.semc.mq.strategy.handler;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.semc.common.enums.MQMessageTypeEnum;
import com.digiwin.athena.semc.mq.dto.MQMessageDTO;
import com.digiwin.athena.semc.mq.dto.NewsLikeMessageDTO;
import com.digiwin.athena.semc.mq.strategy.WorkCommonMessageStrategy;
import com.digiwin.athena.semc.service.news.NewsAnnouncementLikeService;

import org.springframework.stereotype.Service;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Service
@Slf4j
@RequiredArgsConstructor
public class NewsLikeMQHandler  implements WorkCommonMessageStrategy {

    private final NewsAnnouncementLikeService newsAnnouncementLikeService;


    @Override
    public MQMessageTypeEnum getType() {
        return MQMessageTypeEnum.NEWS_LIKE;
    }

    @Override
    public boolean doHandler(MQMessageDTO messageDTO)  {
        newsAnnouncementLikeService.handlerLikeEvent(JSON.parseObject(messageDTO.getMessage(), NewsLikeMessageDTO.class));
        return true;
    }
}
