package com.digiwin.athena.semc.mq.strategy.handler;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.semc.common.enums.MQMessageTypeEnum;
import com.digiwin.athena.semc.mq.dto.MQMessageDTO;
import com.digiwin.athena.semc.mq.strategy.WorkCommonMessageStrategy;
import com.digiwin.athena.semc.proxy.aim.dto.MessageBatchUserDTO;
import com.digiwin.athena.semc.proxy.aim.service.AimService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Collections;

@Service
@Slf4j
@RequiredArgsConstructor
public class NewsSendNoticeMQHandler implements WorkCommonMessageStrategy {

    private final AimService aimService;

    @Override
    public MQMessageTypeEnum getType() {
        return MQMessageTypeEnum.NEWS_SEND_NOTICE;
    }

    @Override
    public boolean doHandler(MQMessageDTO messageDTO) {
        MessageBatchUserDTO messageBatchUserDTO = JSON.parseObject(messageDTO.getMessage(), MessageBatchUserDTO.class);
        // 发送工作提醒
        aimService.sendNoticeMessage(Collections.singletonList(messageBatchUserDTO));
        return true;
    }
}
