package com.digiwin.athena.semc.proxy.aim.dto;

import lombok.Data;
import lombok.NoArgsConstructor;
import com.alibaba.fastjson.JSONObject;


import java.time.LocalDateTime;

/**
 * @description 发送工作提醒
 *
 * @author: sungqz
 * @create: 2025-03-20
 */
@Data
@NoArgsConstructor
public class MessageDTO {

    private String gid;

    private String userId;

    private String tenantId;

    /**
     * 消息类型，如：项目：TASK；任务：ACTIVITY
     */
    private String type;

    /**
     * 重要性，0：不重要，1：重要
     */
    private Integer importance;

    private String source;

    /**
     * 消息状态，消息状态，0：未读，1：已读，3：过期，4：关闭
     */
    private Integer state;

    /**
     * 是否已经查看详情
     */
    private Boolean hasReadDetail;

    private String title;

    private JSONObject content;

    private String jsonContent;

    /**
     * 消息发送时间
     */
    private LocalDateTime sendDate;

    /**
     * 消息生效时间
     */
    private LocalDateTime startTime;

    private LocalDateTime createDate;

    /**
     * 是否需要通知到在线客户
     */
    private Boolean noticeOnlineUser;

    /**
     * 是否需要通知到移动端APP
     */
    private Boolean noticeMobileApp;

    /**
     * 语言 zh_CN:简体 zh_TW：繁体
     */
    private String locale;

    /**
     * 是否过滤非终止消息 ture: 过滤, false: 不过滤
     */
    private Boolean unterminate = false;

    /**
     * 跳转链接
     */
    private String detailUrl;
}
