package com.digiwin.athena.semc.proxy.aim.service;


import com.digiwin.athena.semc.proxy.aim.dto.MessageBatchUserDTO;
import com.digiwin.athena.semc.proxy.aim.dto.TenantRouteTypeEnum;

import java.util.List;

public interface AimService {

    /**
     * 获取租户当前app路由类型
     *
     * @param app
     * @return
     */
    TenantRouteTypeEnum getTenantRouteType(String app);

    /**
     * 删除消息渠道
     * @param tenantId
     */
    void removeMessageChannel(String tenantId);

    /**
     * 获取租户当前semcweb的路由类型
     *
     * @return
     */
    TenantRouteTypeEnum getTenantRouteTypeBySemcWeb();

    /**
     * 发送工作提醒
     *
     * @param messageBatchUserList 请求对象
     */
    void sendNoticeMessage(List<MessageBatchUserDTO> messageBatchUserList);
}
