package com.digiwin.athena.semc.proxy.aim.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.aim.dto.MessageBatchUserDTO;
import com.digiwin.athena.semc.proxy.aim.dto.TenantRouteTypeEnum;
import com.digiwin.athena.semc.proxy.aim.service.AimService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jboss.logging.MDC;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.Map;

@Service
@Slf4j
@RequiredArgsConstructor
public class AimServiceImpl implements AimService {

    private final EnvProperties envProperties;

    private final RestTemplate restTemplate;

    @Override
    public TenantRouteTypeEnum getTenantRouteType(String app) {
        TenantRouteTypeEnum tenantRouteTypeEnum = null;
        // header信息
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(null, headers);
        StringBuilder url = new StringBuilder(envProperties.getAimUrl()).append("/api/aim/v1/tenant/route/getType?app=").append(app);
        try {
            log.info("getTenantRouteTypeReq：{}", app);
            ResponseEntity<JSONObject> respEntity = restTemplate.exchange(url.toString(), HttpMethod.GET,
                    requestEntity, JSONObject.class);
            if (org.apache.http.HttpStatus.SC_OK == respEntity.getStatusCodeValue() && MapUtils.isNotEmpty(respEntity.getBody())) {
                log.info("getTenantRouteTypeResp：{}", respEntity.getBody());
                tenantRouteTypeEnum = TenantRouteTypeEnum.valueOf(respEntity.getBody().getString("response"));
            } else {
                log.info("getTenantRouteTypeEmptyResp：{}", JSON.toJSONString(respEntity));
            }
        } catch (Exception ex) {
            log.error("getTenantRouteTypeEx", ex);
        }
        return tenantRouteTypeEnum;
    }

    @Override
    public void removeMessageChannel(String tenantId) {
        // header信息
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(null, headers);
        StringBuilder url = new StringBuilder(envProperties.getAimUrl()).append("/api/aim/v2/message/removeMessageChannel?tenantId=").append(tenantId);
        try {
            restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity, JSONObject.class);
        } catch (Exception ex) {
            log.error("removeMessageChannelEx", ex);
        }

    }

    @Override
    public TenantRouteTypeEnum getTenantRouteTypeBySemcWeb() {
        return getTenantRouteType("semcweb");
    }

    /**
     * 发送工作提醒
     *
     * @param messageBatchUserList 请求对象
     */
    @Override
    public void sendNoticeMessage(List<MessageBatchUserDTO> messageBatchUserList) {
        // header信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = String.valueOf(MDC.get("userToken"));
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", envProperties.getAppToken());

        // 请求体
        HttpEntity<Object> requestEntity = new HttpEntity<>(messageBatchUserList, headers);
        StringBuilder url = new StringBuilder(envProperties.getAimUrl()).append("/api/aim/v2/batch/user/message");
        try {
            log.info("start send notice message. url:{}, request:{}", url, JSONObject.toJSONString(requestEntity));
            ResponseEntity<JSONObject> respEntity = restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class);
            if (org.apache.http.HttpStatus.SC_OK == respEntity.getStatusCodeValue() && ObjectUtils.isNotEmpty(respEntity.getBody())) {
                log.info("send notice message success. url:{}, request:{}, resp:{}", url, requestEntity, JSONObject.toJSONString(respEntity.getBody()));
            } else {
                log.warn("send notice message return empty. url:{}, request:{}, resp:{}", url, requestEntity, JSONObject.toJSONString(respEntity.getBody()));
            }
        } catch (Exception ex) {
            log.error("send notice message error. url:{}, request:{}, errorMessage:{}", url, requestEntity, ex.getMessage());
            throw BusinessException.create(ex.getMessage());
        }
    }
}
