package com.digiwin.athena.semc.proxy.ania.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.semc.dto.BaseResultDTO;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.ania.service.AniaService;
import com.digiwin.athena.semc.proxy.ania.service.model.KnowledgeAssistantDTO;
import com.digiwin.athena.semc.util.Utils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * Ania相关接口
 */
@Service
@Slf4j
public class AniaServiceImpl implements AniaService {

    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;

    private static final String QUERY_KNOWLEDGE_URL = "/ania/api/assistant/getKnowledgeAssistants?code=DWCK0130NavAsst";


    @Override
    public List<KnowledgeAssistantDTO> getKnowledgeAssistants(String tenantId) {
        List<KnowledgeAssistantDTO> knowledgeAssistantDTOArrayList = new ArrayList<>();
        // header信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", Utils.getUserToken());

        // 请求体
        HttpEntity<?> requestEntity = new HttpEntity<>(null, headers);
        StringBuilder url = new StringBuilder(envProperties.getAniaUrl()).append(QUERY_KNOWLEDGE_URL);
        try {
            log.info("getKnowledgeAssistants. url:{}", url);
            ResponseEntity<JSONObject> respEntity = restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity,
                    new ParameterizedTypeReference<JSONObject>() {
                    });
            log.info("getKnowledgeAssistants. url:{}, resp:{}", url, JSON.toJSONString(respEntity.getBody()));
            if (org.apache.http.HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                BaseResultDTO baseResultDTO = JSON.parseObject(JSON.toJSONString(respEntity.getBody()), BaseResultDTO.class);
                knowledgeAssistantDTOArrayList = JSON.parseArray(JSON.toJSONString(baseResultDTO.getResponse()), KnowledgeAssistantDTO.class);
            } else {
                return knowledgeAssistantDTOArrayList;
            }
            if(CollectionUtils.isNotEmpty(knowledgeAssistantDTOArrayList)){
                knowledgeAssistantDTOArrayList = knowledgeAssistantDTOArrayList.stream().filter(
                    d->{
                        boolean x = false;
                        if(Objects.nonNull(d.getAssistantCode()) &&
                                (d.getAssistantCode().contains("public") || d.getAssistantCode().contains(tenantId) )){
                            x = true;
                        }
                        return x;
                    }
                ).collect(Collectors.toList());
            }

        } catch (Exception e) {
            return knowledgeAssistantDTOArrayList;
        }
        return knowledgeAssistantDTOArrayList;
    }
}