package com.digiwin.athena.semc.proxy.athena.service.atmc;

import com.digiwin.athena.semc.dto.homepage.HomeSearchDTO;
import com.digiwin.athena.semc.proxy.athena.service.atmc.model.GroupRuleDTO;
import com.digiwin.athena.semc.proxy.athena.service.atmc.model.GroupValueDTO;
import net.sf.json.JSONObject;

import java.util.List;

/**
 * atmc invoke
 *
 * @author sunqgz
 * @since 2024-07-30
 */
public interface AtmcService {

    /**
     * 首页搜索
     *
     * @param name
     * @param userToken
     * @param type
     * @return
     */
    List<HomeSearchDTO> searchResult(String name, String userToken, Integer type);

    /**
     * 查询分组条件
     *
     * @return 返回
     */
    List<GroupRuleDTO> queryGroupRule();

    /**
     * 查询分组条件值
     *
     * @param groupCode 分组条件code
     * @return 返回
     */
    List<GroupRuleDTO> queryGroupConditionRule(String groupCode);

    /**
     * 根据分组条件查询分组待办数
     *
     * @param clientId 客户端id
     * @param groupList 分组条件
     * @return 返回
     */
    List<GroupValueDTO> queryGroupTodoValue(String clientId, List<JSONObject> groupList);
}