package com.digiwin.athena.semc.proxy.athena.service.atmc.impl;

import com.google.common.collect.Maps;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.semc.dto.BaseResultDTO;
import com.digiwin.athena.semc.dto.homepage.HomeSearchDTO;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.athena.service.atmc.AtmcService;
import com.digiwin.athena.semc.proxy.athena.service.atmc.model.GroupRuleDTO;
import com.digiwin.athena.semc.proxy.athena.service.atmc.model.GroupValueDTO;
import com.digiwin.athena.semc.util.Utils;

import net.sf.json.JSONObject;

import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * atmc invoke
 *
 * @author sunqgz
 * @since 2024-07-30
 */
@Service
@Slf4j
public class AtmcServiceImpl implements AtmcService {

    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;

    /**
     * 查询分组条件url
     */
    private static final String QUERY_GROUP_URL = "/api/atmc/v1/semc/groupRule";

    /**
     * 查询分组条件值url
     */
    private static final String QUERY_GROUP_CONDITION_URL = "/api/atmc/v1/semc/groupRuleOptions?groupCode=";

    /**
     * 根据分组条件查询待办数url
     */
    private static final String QUERY_GROUP_VALUE_URL = "/api/atmc/v1/semc/backlogQuantity";

    private static final String SEARCH_RESULT = "/api/atmc/v1/search/result";

    @Override
    public List<HomeSearchDTO> searchResult(String name, String userToken, Integer type) {
        List<HomeSearchDTO> athenaSearchResult = new ArrayList<>();
        // header信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("token", userToken);
        // 请求体
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("name", name);
        requestMap.put("type", type);
        HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(requestMap, headers);
        StringBuilder url = new StringBuilder(envProperties.getTaskmapUrl()).append(SEARCH_RESULT);
        try {
            log.info("请求小AI获取搜素结果start url:{},userToken:{},req:{}", url, userToken, requestMap);
            ResponseEntity<JSONObject> respEntity = restTemplate.exchange(url.toString(), HttpMethod.POST,
                    requestEntity, JSONObject.class);
            //这个返回日志有点大
            //log.info("请求小AI获取搜素结果 url:{},userToken:{},req:{},resp:{}", url, userToken, requestMap, JSON.toJSONString(respEntity.getBody()));
            if (org.apache.http.HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                BaseResultDTO baseResultDTO = JSON.parseObject(JSON.toJSONString(respEntity.getBody()), BaseResultDTO.class);
                athenaSearchResult = JSON.parseArray(JSON.toJSONString(baseResultDTO.getResponse()), HomeSearchDTO.class);
            }
        } catch (Exception e) {
            log.error("请求小AI获取搜素结果异常, 用户token:{},   request:{}, url:{}, errorMsg:{}", userToken, requestMap, url, e);
            return athenaSearchResult;
        }
        return athenaSearchResult;
    }

    /**
     * 查询分组条件
     *
     * @return 返回结果
     */
    @Override
    public List<GroupRuleDTO> queryGroupRule() {
        List<GroupRuleDTO> groupRuleList = new ArrayList<>();

        // header信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", Utils.getUserToken());

        // 请求体
        HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(null, headers);
        // url
        StringBuilder url = new StringBuilder(envProperties.getTaskmapUrl()).append(QUERY_GROUP_URL);
        try {
            ResponseEntity<JSONObject> respEntity = restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity,
                    new ParameterizedTypeReference<JSONObject>() {
                    });
            log.info("query group rule end. url:{}, param:{}, resp:{}", url, requestEntity, JSON.toJSONString(respEntity.getBody()));
            if (org.apache.http.HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                BaseResultDTO baseResultDTO = JSON.parseObject(JSON.toJSONString(respEntity.getBody()), BaseResultDTO.class);
                groupRuleList = JSON.parseArray(JSON.toJSONString(baseResultDTO.getResponse()), GroupRuleDTO.class);
            } else {
                log.error("query group rule fail. url:{}, param:{}, resp:{}", url, requestEntity, respEntity.getBody());
                return groupRuleList;
            }
        } catch (Exception e) {
            log.error("query group rule error. url:{}, param:{}", url, requestEntity, e);
            return groupRuleList;
        }
        return groupRuleList;
    }

    /**
     * 查询分组条件值
     *
     * @return 返回结果
     */
    @Override
    public List<GroupRuleDTO> queryGroupConditionRule(String groupCode) {
        List<GroupRuleDTO> groupRuleList = new ArrayList<>();

        // header信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", Utils.getUserToken());

        // 请求体
        HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(null, headers);
        // url
        StringBuilder url = new StringBuilder(envProperties.getTaskmapUrl()).append(QUERY_GROUP_CONDITION_URL).append(groupCode);
        try {
            ResponseEntity<JSONObject> respEntity = restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity,
                    new ParameterizedTypeReference<JSONObject>() {
                    });
            log.info("query group condition rule end. url:{}, param:{}, resp:{}", url, requestEntity, JSON.toJSONString(respEntity.getBody()));
            if (org.apache.http.HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                BaseResultDTO baseResultDTO = JSON.parseObject(JSON.toJSONString(respEntity.getBody()), BaseResultDTO.class);
                groupRuleList = JSON.parseArray(JSON.toJSONString(baseResultDTO.getResponse()), GroupRuleDTO.class);
            } else {
                log.error("query group condition rule fail. url:{}, param:{}, resp:{}", url, requestEntity, respEntity.getBody());
                return groupRuleList;
            }
        } catch (Exception e) {
            log.error("query group condition rule error. url:{}, param:{}", url, requestEntity, e);
            return groupRuleList;
        }
        return groupRuleList;
    }

    /**
     * 根据分组条件查询待办数
     *
     * @param clientId  客户端id
     * @param groupList 分组条件
     * @return 返回
     */
    @Override
    public List<GroupValueDTO> queryGroupTodoValue(String clientId, List<JSONObject> groupList) {
        List<GroupValueDTO> groupValueList = new ArrayList<>();

        // header信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", Utils.getUserToken());

        // 请求体
        Map<String, Object> map = Maps.newHashMap();
        map.put("clientId", clientId);
        map.put("groups", groupList);
        HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(map, headers);
        // url
        StringBuilder url = new StringBuilder(envProperties.getTaskmapUrl()).append(QUERY_GROUP_VALUE_URL);
        try {
            ResponseEntity<JSONObject> respEntity = restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity,
                    new ParameterizedTypeReference<JSONObject>() {
                    });
            log.info("query group Todo value end. url:{}, param:{}, resp:{}", url, requestEntity, JSON.toJSONString(respEntity.getBody()));
            if (org.apache.http.HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                BaseResultDTO baseResultDTO = JSON.parseObject(JSON.toJSONString(respEntity.getBody()), BaseResultDTO.class);
                groupValueList = JSON.parseArray(JSON.toJSONString(baseResultDTO.getResponse()), GroupValueDTO.class);
            } else {
                log.error("query group Todo value fail. url:{}, param:{}, resp:{}", url, requestEntity, respEntity.getBody());
                return groupValueList;
            }
        } catch (Exception e) {
            log.warn("query group Todo value error{}", e.getMessage(),e);
            return groupValueList;
        }
        return groupValueList;
    }
}