package com.digiwin.athena.semc.proxy.athena.service.audc;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.proxy.athena.service.audc.model.AuthorityMenuDTO;
import com.digiwin.athena.semc.proxy.athena.service.audc.model.SystemMenuDTO;
import com.digiwin.athena.semc.proxy.athena.service.audc.model.UserTrackExtendDTO;

import java.util.List;

/**
 * 请求小AI相关接口
 */
public interface AudcService {
    /**
     * 查询所有系统菜单
     *
     * @return 返回结果
     */
    List<SystemMenuDTO> querySystemMenu();

    /**
     * 查询用户级的菜单（作业和系统菜单）权限
     *
     * @return 返回结果
     */
    List<AuthorityMenuDTO> queryAuthorityMenu(JSONArray reqBody);

    void reportUserTrack(AuthoredUser authoredUser, List<UserTrackExtendDTO> list);

}