package com.digiwin.athena.semc.proxy.cac.service;


import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.semc.proxy.cac.service.dto.TenantAuthAppDTO;
import com.digiwin.athena.semc.proxy.cac.service.dto.UserAppDTO;
import io.vavr.Tuple2;

import java.util.List;

/**
 * @description cac invoke
 * @author: sungqz
 * @create: 2023-8-7
 */
public interface CacService {

    /**
     * 调用鼎捷云接口校验租户是否授权应用
     *
     * @param tenantId 租户id
     * @param code     应用code
     * @return
     */
    boolean verifyAppAuthorized(String tenantId, String code);

    /**
     * 调用鼎捷云接口校验租户是否授权应用
     *
     * @param tenantId 租户id
     * @param code     应用code
     */
    Tuple2<String, Boolean> verifyAppAuthorizedResult(String tenantId, String code);

    /**
     * 查询当前登录用户可用的应用清单信息
     *
     * @return
     */
    JSONArray queryCurrentUserAppList();

    /**
     * 查询当前指定用户所有的应用权限
     *
     * @return 应用权限列表
     */
    List<UserAppDTO> queryUserApp(String userId);

    /**
     * 查询当前登录用户所有的应用权限
     *
     * @return 应用权限列表
     */
    List<UserAppDTO> queryUserApp();

    /**
     * 查询当前租户的应用授权列表
     *
     * @param expireType 过期类型，0-未过期、1-已过期、2-查询全部
     * @return 租户的应用授权列表
     */
    TenantAuthAppDTO queryTenantApp(int expireType);

}