package com.digiwin.athena.semc.proxy.emc.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.semc.proxy.emc.service.model.OmEventResp;

import java.util.List;

/**
 * @description emc invoke
 * @author: sungqz
 * @create: 2024-1-8
 */
public interface EmcService {

    /**
     * 获取员工所在部门以及所有的上级部门
     *
     * @param channelFlag 渠道标识  email:邮件 sms:短信 wecom:企微 dingTalk:钉钉
     * @return nameConditon 名称过滤关键字
     */
    List<OmEventResp> queryOmTemplateList(String channelFlag, String nameConditon);

    /**
     * 查询企微配置
     *
     * @param userToken 用户token
     * @return 返回
     */
    JSONObject queryWeComConfig(String userToken);

    /**
     * 发送企微消息
     *
     * @param userIdList 消息发送用户列表
     * @param msg        消息内容
     * @param userToken  userToken
     */
    void sendWeChat(List<String> userIdList, String msg, String userToken);
}