package com.digiwin.athena.semc.proxy.emc.service.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * OM平台事件下渠道列表
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OmEventTemplateDTO implements Serializable  {

    private static final long serialVersionUID = -895405632762372851L;

    /**
     * sid
     */
    private String sid;

    /**
     * 主旨
     */
    private String subject;

    /**
     * 语言
     */
    private String language;

    /**
     * 预览内容的类型 1：取templateUrl预览 2：取subject预览 3：不支持预览
     */
    private Integer previewType;

    /**
     * 模板id
     */
    private String templateId;

    /**
     * 模板名称
     */
    private String templateName;

    /**
     * 模板地址
     */
    private String templateUrl;

    /**
     * 修改人
     */
    private String modifyBy;

    /**
     * 修改时间
     */
    private String modifyDate;
}