package com.digiwin.athena.semc.proxy.eoc.service;

import com.digiwin.athena.semc.proxy.eoc.service.model.UserDeptDTO;
import com.digiwin.athena.semc.proxy.eoc.service.model.UserDeptInfoDTO;
import com.digiwin.athena.semc.proxy.eoc.service.model.UserInfoDetailDTO;

import java.util.List;

/**
 * @description eoc invoke
 * @author: sungqz
 * @create: 2023-7-18
 */
public interface EocService {

    /**
     * 获取员工所在部门以及所有的上级部门
     *
     * @return 员工所在部门以及所有的上级部门
     */
    List<UserDeptInfoDTO> queryUserDeptList(String empId);

    /**
     * 获取鼎捷云登录用户对应的员工工号
     * @return
     */
    String getEmpJobNum();

    /**
     * 获取员工详情的接口
     *
     * @param userId 用户id
     * @return 返回
     */
    UserInfoDetailDTO queryUserInfoDetail(String userId);


    /**
     * 获取员工部门sid集合
     * @param userId
     * @return
     */
    List<Long> queryUserDeptSidList(String userId);


    /**
     * 批量查询部门下用户列表
     *
     * @param deptSidList 部门sid列表
     * @return 返回对象
     */
    List<UserDeptInfoDTO> queryUserByDeptSidList(List<Long> deptSidList);

    /**
     * 查询当前租户下部门列表
     *
     * @return 返回
     */
    List<UserDeptDTO> queryTenantDeptList();
}