package com.digiwin.athena.semc.proxy.es.service;

import com.digiwin.athena.semc.dto.homepage.AdvertisementDTO;

import java.util.List;

/**
 * @description es invoke
 * @author: sungqz
 * @create: 2023-8-23
 */
public interface EsService {

    /**
     * 调用es服务获取广告列表
     *
     * @param serviceRegion 服务中心
     * @param adLaunchArea  广告投放区域
     * @param esAccessToken esAccessToken
     * @return
     */
    List<AdvertisementDTO> queryAdList(String serviceRegion, String adLaunchArea, String esAccessToken);

    /**
     * 服务云阅读广告记录
     *
     * @param adId                广告id
     * @param customerServiceCode 客服代号
     * @param esUserId            esUserId
     * @param esAccessToken       esAccessToken
     * @return
     */
    boolean readServiceCloud(Long adId, String customerServiceCode, String esUserId, String esAccessToken);
}