package com.digiwin.athena.semc.proxy.esp.service;

import com.digiwin.athena.semc.dto.PageInfo;

import java.util.Map;

/**
 * @Author: sunyfa
 * @CreateTime: 2022/12/9 11:46
 * @Description: 对接 ESP 服务
 * @Version: 1.0
 */
public interface ESPService {
    /**
     * 发起 ESP 查询
     *
     * @param serviceProd    服务端产品名称
     * @param serviceUID     服务端UID，确定是哪个实例
     * @param serviceName    服务端产品服务名称
     * @param extHeader      header参数
     * @param parameter      请求参数
     * @param pageInfo       分页
     * @param queryCondition 查询条件
     * @return
     */
    Map<String, Object> queryByEsp(String serviceProd, String serviceUID, String serviceName,
        Map<String, String> extHeader, Map<String, Object> parameter, String queryCondition, PageInfo pageInfo);
}
