package com.digiwin.athena.semc.proxy.fineReport.model.resp;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;


/**
 * 帆软平台目录接口返回对象
 *
 * @author sunqgz
 * @since 2025-08-11
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class FineReportTreeVO implements Serializable {

    private static final long serialVersionUID = -3951889655915316906L;

    /**
     * 目录/报表id
     */
    private String id;

    /**
     * 父目录id
     */
    private String pId;

    /**
     * 目录/报表名称
     */
    private String text;

    /**
     * 目录/报表路径
     */
    private String path;

    /**
     * 目录描述
     */
    private String description;

    /**
     * 显示类型
     * 0：未勾选 PC 、平板、手机
     * 1：PC
     * 2：平板
     * 3：PC 、平板
     * 4：手机
     * 5：勾选 PC 、手机
     * 6：勾选平板、手机
     * 7：勾选 PC 、平板、手机
     */
    private Integer deviceType;

    /**
     * 平台类型
     * 1：平台管理系统节点
     * 2：首页
     * 3：目录
     * 5：链接
     * 6：文件
     * 报表类型
     * 101：上报流程
     * 102：FineReport 报表
     * BI 类型
     * 201：BI 报表
     */
    private Integer entryType;

    /**
     * 排序顺序
     */
    private Integer sortIndex;

    /**
     * 是否是父级目录
     */
    private Boolean isParent;

    /**
     * 父级设备类型
     */
    private Integer parentDeviceType;

    /**
     * 是否有权限 false:否 true:是
     */
    private Boolean havePermissionFlag;
}
