package com.digiwin.athena.semc.proxy.fineReport.service;

import com.digiwin.athena.semc.proxy.fineReport.model.resp.FineReportTreeVO;
import com.digiwin.athena.semc.proxy.fineReport.model.resp.FineReportUserVO;

import java.util.List;

/**
 * 帆软报表系统服务
 *
 * @author sunqgz
 * @since 2025-08-11
 */
public interface FineReportProxyService {

    /**
     * 查询帆软平台目录树接口
     *
     * @param deviceType 设备类型
     * @return 返回
     */
    List<FineReportTreeVO> queryFineReportEntryTree(String clientId, String secret, String deviceType);

    /**
     * 添加帆软用户信息
     *
     * @param fineReportUserVO 帆软用户
     */
    void addFineReportUser(String clientId, String secret, FineReportUserVO fineReportUserVO);

    /**
     * 修改帆软用户信息
     *
     * @param fineReportUserVO 帆软用户
     */
    void updateFineReportUser(String clientId, String secret, FineReportUserVO fineReportUserVO);

    /**
     * 删除帆软用户信息
     *
     * @param frUserId 帆软用户ID
     */
    void deleteFineReportUser(String clientId, String secret, String frUserId);

    /**
     * 查询帆软用户信息
     *
     * @param frUserId 帆软用户ID
     * @return 帆软用户
     */
    List<FineReportUserVO> queryFineReportUser(String clientId, String secret, String frUserId);
}