package com.digiwin.athena.semc.proxy.gmc.service.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.semc.dto.homepage.UpgradeInfoDTO;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.gmc.service.IGmcService;
import com.digiwin.athena.semc.util.DateUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Service
@Slf4j
public class GmcServiceImpl implements IGmcService {
    private static final int PAGE_SIZE = 999;

    @Resource
    private RestTemplate restTemplate;

    @Resource
    private EnvProperties envProperties;

    /**
     * @description: 查询版更信息
     * @param elaborate true:返回detail false:不返回detail 不传默认false
     * @param sid 传了sid，就只用sid查
     * @return 版更详情对象
     * @author: sunyfa
     */
    @Override
    public List<UpgradeInfoDTO> getDeploy(boolean elaborate, String sid) {
        // 构建请求头
        HttpHeaders headers = new HttpHeaders();
        headers.add(GlobalConstant.IAM_USER_TOKEN, AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add(GlobalConstant.IAM_APP_TOKEN, envProperties.getAppToken());

        // 构建请求体
        Map<String, Object> param = new HashMap<>();
        param.put("platform", "Athena");
        String currentDate = DateUtils.getNowTime(DateUtils.DATE_TIME_NORMAL_FORMATTER);
        param.put("startTime", DateUtils.addDate(currentDate, DateUtils.DATE_TIME_NORMAL_FORMATTER, -1, DateUtils.YEAR));
        param.put("endTime", currentDate);
        param.put("pageSize", PAGE_SIZE);
        param.put("sid", sid);
        param.put("elaborate", elaborate);

        HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(param, headers);
        StringBuilder url = new StringBuilder(envProperties.getGmcUri()).append("/api/gmc/v2/release/query");
        try {
            log.info("GmcServiceImpl getDeploy URL:{}, param:{}", url, JsonUtils.objectToString(requestEntity));
            ResponseEntity<JSONObject> respEntity = restTemplate.exchange(url.toString(), HttpMethod.POST,
                    requestEntity, JSONObject.class);
            log.info("GmcServiceImpl getDeploy result:{}", JsonUtils.objectToString(respEntity));

            if (org.apache.http.HttpStatus.SC_OK == respEntity.getStatusCodeValue() && Objects.nonNull(respEntity.getBody())) {
                return JsonUtils.jsonToListObject(String.valueOf(respEntity.getBody().get("data")), UpgradeInfoDTO.class);
            } else {
                log.error("拉取版更信息失败, 请求体：{}, url:{}, 响应内容：{}", JsonUtils.objectToString(requestEntity), url, JsonUtils.objectToString(respEntity.getBody()));
                return null;
            }
        } catch (Exception ex) {
            log.error("拉取版更信息异常, 请求体：{}, url：{}", JsonUtils.objectToString(requestEntity), url, ex);
            return null;
        }
    }
}
