package com.digiwin.athena.semc.proxy.iam.service;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.dto.erpsso.AuthorizeDTO;
import com.digiwin.athena.semc.dto.erpsso.RegisterDTO;
import com.digiwin.athena.semc.entity.applink.TenantAppDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.*;
import com.digiwin.athena.semc.proxy.iam.service.model.req.UserAllPermissionReqDTO;
import com.digiwin.athena.semc.proxy.iam.service.model.resp.AppTenantRespVO;
import com.digiwin.athena.semc.proxy.iam.service.model.resp.TenantUserRespVO;
import com.digiwin.athena.semc.proxy.iam.service.model.resp.UserAllPermissionBaseRespVO;
import com.digiwin.athena.semc.vo.common.PermissionUserFunctionalDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationDTO;
import com.digiwin.athena.semc.vo.common.UserApplicationSimpleDTO;
import com.digiwin.athena.semc.vo.portal.AppExistVO;
import org.springframework.http.ResponseEntity;

import java.util.List;
import java.util.Map;

/**
 * @description iam invoke
 * @author: sungqz
 * @create: 2022-11-28
 */
public interface IamService {

    /**
     * 注册应用
     *
     * @param registerDTO 请求体
     * @return
     */
    Long registerApp(RegisterDTO registerDTO) throws Exception;

    /**
     * 更新应用该信息，目的是将appId和appSecret重新绑定应用
     *
     * @param registerDTO 请求体
     * @return
     */
    Long updateAppInfoForIAM(RegisterDTO registerDTO) throws Exception;

    /**
     * 获取应用appId和appSecret
     *
     * @param appSid   应用sid
     * @param appToken appToken
     * @return
     */
    RegisterDTO queryAppInfo(Long appSid, String appToken) throws Exception;

    /**
     * 校验 userToken 的有效性
     *
     * @param userToken
     * @param appToken
     * @return
     */
    boolean checkUserToken(String userToken, String appToken);

    /**
     * 获取当前租户下的应用清单
     *
     * @return 当前租户下的应用清单
     */
    List<TenantAppDTO> queryTenantApps();

    /**
     * 获取当前租户下登录的IAM云端账号绑定的三方员工账号
     *
     * @param appId    appId
     * @return IAM云端账号绑定的三方员工账号
     */
    String queryMappingEmpId(String appId);

    /**
     * 鼎捷云获取用户行为权限配置
     *
     * @param authoredUser 用户信息
     * @return
     */
    JSONArray queryUserPermissionV2(AuthoredUser authoredUser);

    /**
     * @param
     * @return
     * @description: 查询当前用户所在的组织
     * @author: sunyfa
     */
    UserOrgInfoDTO qryUserOrgInfo(String userId, String token);

    /**
     * 查询当前用户所在的组织
     * @param userId
     * @param token
     * @return
     */
    List<Long> qryUserOrgSidList(String userId, String token);

    /**
     * @param
     * @return
     * @description: 查询当前用户所在的角色
     * @author: sunyfa
     */
    List<RoleDTO> queryUserRoles(String userId, String token);


    /**
     * 查询当前用户所在的角色
     * @param userId
     * @param token
     * @return
     */
    List<Long> queryUserRolesSidList(String userId, String token);

    /**
     * 查询当前租户下所有用户列表
     *
     * @return
     */
    List<RoleDTO> queryAllUserList();

    /**
     * 查询当前租户下所有启用的用户列表
     *
     * @return
     */
    public List<RoleDTO> queryEnabledUserList();

    /**
     * 查询所有申请过appToken的应用列表
     *
     * @return 应用列表
     */
    List<AppExistVO.AppDTO> queryAppListExistAppToken() throws Exception;

    /**
     * 根据sid查询appToken
     *
     * @param sid sid
     * @return
     */
    Map<String, Object> queryAppTokenBySid(Long sid);

    /**
     * 获取授权信息
     *
     * @param appId       应用id
     * @param callbackUrl 回调地址
     * @return
     */
    AuthorizeDTO queryAuthorizeInfo(String appId, String callbackUrl) throws Exception;

    /**
     * 查询用户授权的商品信息
     * http://172.16.2.100:22694/html/web/controller/share/share.html#6441feefeae133071b1a7b89
     *
     * @return
     */
    List<UserApplicationDTO> queryUserApplication();

    /**
     * 查询用户授权的商品信息
     * http://172.16.2.100:22694/html/web/controller/share/share.html#6441feefeae133071b1a7b89
     * @param filterAppExpired 是否过滤掉过期的商品
     * @param filterModuleExpired 是否过滤掉过期的模块
     * @param validPermission 是否验证权限使用场景（true，就不会返回name）
     * @return
     */
    List<UserApplicationSimpleDTO> queryUserApplicationSimple(boolean filterAppExpired, boolean filterModuleExpired, boolean validPermission);

    /**
     * 取得单一用户在某个应用的功能权限运算结果
     *
     * @param target 為應用/模組/行為uri
     * @param target 為應用/模組/行為uri
     * @return
     */
    List<PermissionUserFunctionalDTO> queryUserFunctional(String target, AuthoredUser authoredUser);

    /***
     * 获取公司别厂别
     * @return
     */
    JSONArray getCompanyFactory();

    /**
     * 获取Iam 登录用户的邮箱信息
     *
     * @return
     */
    List<String> getIamEmail();

    /**
     * 检查SAML回调地址是否存在并添加配置
     *
     * @param successCallbackUrl 成功回调地址
     * @param failCallbackUrl    失败回调地址
     * @return
     */
    ResponseEntity<?> checkExitAndAddSAMLCallbackUrl(String successCallbackUrl, String failCallbackUrl);

    /**
     * 更新SAML回调地址
     *
     * @param successCallbackUrl 成功回调地址
     * @param failCallbackUrl    失败回调地址
     * @return
     */
    ResponseEntity<?> addSamlCallbackUrl(String successCallbackUrl, String failCallbackUrl);

    /**
     * saml授权码置换userToken
     *
     * @param authCode 授权码
     * @return token
     */
    ResponseEntity<?> queryUserTokenByAuthCode(String authCode, String ssoType);

    /**
     * 批量查询组织下用户列表
     *
     * @param orgSidList 组织sid列表（不能超过100个）
     * @return 返回对象
     */
    List<OrgRoleUserDTO> queryUserByOrgSidList(List<Long> orgSidList);


    /**
     * 批量查询组织下用户列表
     * 底层调用拆分后调用 IamService#queryUserByOrgSidList
     * @param orgSidList
     * @return
     */
    List<OrgRoleUserDTO> queryUserByAllOrgSidList(List<Long> orgSidList);

    /**
     * 批量查询角色下用户列表
     * http://172.16.2.100:22694/html/web/controller/share/share.html#6544624bc697320cfb22a75b
     * @param roleSidList 角色sid列表（不能超过100个）
     * @return 返回对象
     */
    List<OrgRoleUserDTO> queryUserByRoleSidList(List<Long> roleSidList);


    /**
     * 批量查询角色下用户列表
     * 底层调用拆分后调用 IamService#queryUserByRoleSidList
     * @param roleSidList
     * @return
     */
    List<OrgRoleUserDTO> queryUserByAllRoleSidList(List<Long> roleSidList);

    /**
     * 查询用户语言别
     *
     * @return 返回结果
     */
    String queryUserLangMetadata();

    /**
     * 新增sso登录系统的回调地址
     * @param successCallbackUrl
     * @param failCallbackUrl
     * @param logoutCallbackUrl
     * @return
     */
    ResponseEntity<?> addCasCallbackUrl(String successCallbackUrl, String failCallbackUrl, String logoutCallbackUrl);

    /**
     * 当前租户超管批量给用户授权应用权限
     *
     * @param appId      应用id
     * @param userSidList 用户sid列表
     * @param type       操作，Delete-删除，Insert-新增
     * @return 返回
     */
    boolean batchUserAuthorizeApp(String appId, List<Long> userSidList, Integer type);

    /**
     * 根据用户id获取用户相关的信息
     *
     * @param userId 用户id
     * @param sid
     * @param token  合法的token
     * @return 用户基本信息
     */
    UserInfoDTO queryUser(String userId, Long sid, String token);

    /**
     * 根据邮箱获取个人租户
     * -1 调用接口失败
     * 0 没有个人租户
     * 1 没有授权
     * 2 有个人租户并且有授权
     * @Author：SYQ
     * @Date：2021/11/24 14:20
     */
    Map<String, Object> getTenantAuth(AuthoredUser authoredUser, String email, String telephone, String appId, Integer tenantType);

    /**
     * 根据应用编码获取租户相关的信息
     *
     * @param appIds 应用编码
     * @return 租户基本信息
     */
    List<AppTenantDTO> queryTenantByApp(List<String> appIds);


    /**
     * 查询购买了指定应用的租户id
     * http://172.16.2.100:22694/html/web/controller/share/share.html#6441feefeae133071b1a7bd3
     * @param appId 应用编码
     * @return
     */
    List<AppTenantRespVO> queryBuyTenantListByAppId(String appId);


    /**
     * 获取租户下用户列表
     * http://172.16.2.100:22694/html/web/controller/share/share.html#60865d28a646b709247a6a08
     * @param tenantId 租户id
     * @return
     */
    List<TenantUserRespVO> queryUserListByTenantId(String tenantId);

    /**
     * 获取用户的功能权限
     * https://doc.apipost.net/docs/detail/2d0e084b1c64000?target_id=35b8551&locale=zh-cn
     * @param reqDTO
     * @return
     */
    UserAllPermissionBaseRespVO queryUserAllPermission(UserAllPermissionReqDTO reqDTO);


    /**
     * 查询当前租户下所有角色列表
     *
     * @return 返回
     */
    List<RoleDTO> queryAllRoleList();

    /**
     * 查询当前租户下的租户账套映射关系
     *
     * @param appId 应用id
     * @param companyId 公司别
     * @param account 账套id
     * @return 返回
     */
    List<AccountDTO> queryTenantAccountMappingList(String appId, String companyId, String account);

    /**
     * 查询租户的简单信息
     * @return
     */
    TenantSimpleDTO queryTenantSimple();

    /**
     * 获取组织别厂别
     * @return 列表
     */
    List<OrgAspectDTO> getOrgAspect();

    /**
     * 获取集成租户的token
     *
     * @param tenantId 租户id
     * @return 返回
     */
    String queryIntegrationUserToken(String tenantId);

    /**
     * 查询当前租户下三方账号映射的用户信息
     *
     * @param userToken     userToken
     * @param appCode      应用code
     * @param verifyUserId 三方账号
     * @return 返回
     */
    String queryVerifyMappingUser(String userToken, String appCode, String verifyUserId);

    /**
     * 查询当前租户下指定应用系统下的所有归户用户的信息
     *
     * @param userToken     userToken
     * @param appCode      应用code
     * @return 返回
     */
    List<AppUserDTO> queryAllVerifyMappingUser(String userToken, String appCode);
}