package com.digiwin.athena.semc.proxy.iam.service.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：用户群组 组织信息DTO</p>
 * {
 *         "sid": 904977832072192,
 *         "tenantSid": 466712390951488,
 *         "label": "0001",
 *         "name": "市场营销部",
 *         "parentSid": 0,
 *         "orgAspectSid": 466712391684672,
 *         "typeSid": 466712391709248,
 *         "typeUri": "drn:iam:orgtype:defaultOrgCatalog:company",
 *         "typeName": "公司",
 *         "uri": "drn:iam:org:defaultOrgCatalog:defaultOrgAspect:0001",
 *         "urn": "默认租户分类:默认组织树:市场营销部",
 *         "orgTags": [],
 *         "createTime": "2024-08-19 17:56:54",
 *         "userCount": 6,
 *         "activeCount": 6,
 *         "createTimeUTC": "2024-08-19T09:56:54"
 *     }
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: OrgAspectDTO.java
 * @Author: wangjwc
 * @Date: created at 2025/9/8 10:17
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class OrgAspectDTO implements Serializable {
    private static final long serialVersionUID = 5143909280474700192L;

    private Long sid;
    private Long tenantSid;
    private String label;
    private String name;
    private Long parentSid;
    private Long orgAspectSid;
    private Long typeSid;
    /**
     * 公司：drn:iam:orgtype:defaultOrgCatalog:company
     * 工厂：drn:iam:orgtype:defaultOrgCatalog:factory
     * 部门：drn:iam:orgtype:defaultOrgCatalog:department
     */
    private String typeUri;
    private String typeName;
    private String uri;
    private String urn;
    private List orgTags;
    private String createTime;
    private Integer userCount;
    private Integer activeCount;
    private String createTimeUTC;
}
