package com.digiwin.athena.semc.proxy.iam.service.model.resp;

import com.digiwin.athena.semc.proxy.iam.service.model.req.UserAllPermissionReqDTO;

import java.util.List;
import java.util.Map;

import lombok.Data;

@Data
public class UserAllPermissionBaseRespVO {

    private UserAllPermissionReqDTO query;

   private UserAllPermission result;


    @Data
    public static class UserAllPermission{
        private List<Map<String, Object>> roles;

        private Map<String, Object> org;

        private Map<String, Object> tag;

        private Map<String, Object> defaultOrg;

        private List<Object> dataPermissions;

        private Map<String, Object> cacAuthHolder;

        private List<Module> modules;

        private List<Permission> permissions;
    }




    @Data
    public static class Module{
        private Long sid;

        private String id;

        private String name;

        private String effect;
    }

    @Data
    public static class Permission{

        /**
         * 作业sid
         */
        private Long sid;

        /**
         * 作业id
         */
        private String id;


        /**
         * 作业模组id
         */
        private String moduleId;

        /**
         * 作业名称
         */
        private String name;

        /**
         * 作业完整路径
         */
        private String target;

        /**
         * 作业状态：允许/拒绝
         */
        private String effect;

        /**
         * 条件
         */
        private Map<String,Object> conditions;

    }

}
