package com.digiwin.athena.semc.proxy.kbs.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.kbs.service.KbsService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.*;

@Service
@Slf4j
public class KbsServiceImpl implements KbsService {

    private static final String fileQueryUrl = "/restful/standard/kbs/knowledge/permission/base/home/info/get";

    private static final String fileInfoUrl = "/restful/standard/kbs/knowledge/permission/file/detail/get";

    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;


    @Override
    public JSONArray selectKnowledgeInfo(String content) {
        JSONArray resp = new JSONArray();
        String kbsUri = envProperties.getKbsUri();
        StringBuilder kbsUriBuilder = new StringBuilder();
        kbsUriBuilder.append(kbsUri).append(fileQueryUrl);
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.set("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.set("digi-middleware-auth-app", com.digiwin.athena.appcore.auth.GlobalConstant.IAM_APP_TOKEN_ATHENA);
        headers.setContentType(org.springframework.http.MediaType.APPLICATION_JSON);
        Map map = Maps.newHashMap();
        map.put("search_content", content);
        map.put("search_range", "");
        map.put("knowledge_classification_info", Lists.newArrayList());
        map.put("tag_classification_info", Lists.newArrayList());
        map.put("start_time", "");
        map.put("end_time", "");
        Map mapPagination = Maps.newHashMap();
        mapPagination.put("page", 1);
        mapPagination.put("page_size", Constants.MAXPAGESIZE);
        map.put("pagination", mapPagination);
        map.put("tab_no", "all");
        JSONObject req = new JSONObject();
        req.put("knowledge_info", map);
        HttpEntity<?> httpEntity = new HttpEntity<>(req, headers);
        ResponseEntity<net.sf.json.JSONObject> responseEntity = restTemplate.exchange(kbsUriBuilder.toString(), HttpMethod.POST, httpEntity, new ParameterizedTypeReference<net.sf.json.JSONObject>() {
        });
        log.info("Call KBS file query result:{}", JSONObject.toJSONString(responseEntity));
        net.sf.json.JSONObject jsonObjectResponse = (net.sf.json.JSONObject) responseEntity.getBody().get("response");
        if (JSONObject.toJSONString(jsonObjectResponse.get("data")).equals("null")) {
            return resp;
        }
        net.sf.json.JSONObject objectData = (net.sf.json.JSONObject) jsonObjectResponse.get("data");
        net.sf.json.JSONArray jsonArrayKnowledgeInfo = (net.sf.json.JSONArray) objectData.get("knowledge_info");
        return jsonArrayKnowledgeInfo;
    }

    @Override
    public net.sf.json.JSONObject getFileDetail(String fileId) {
        net.sf.json.JSONObject responseData = new net.sf.json.JSONObject();
        String kbsUri = envProperties.getKbsUri();
        StringBuilder kbsUriBuilder = new StringBuilder();
        kbsUriBuilder.append(kbsUri).append(fileInfoUrl);
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.set("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.set("digi-middleware-auth-app", com.digiwin.athena.appcore.auth.GlobalConstant.IAM_APP_TOKEN_ATHENA);
        headers.setContentType(org.springframework.http.MediaType.APPLICATION_JSON);
        Map map = Maps.newHashMap();
        map.put("file_id", fileId);
        JSONObject req = new JSONObject();
        req.put("file_info", map);
        HttpEntity<?> httpEntity = new HttpEntity<>(req, headers);
        ResponseEntity<net.sf.json.JSONObject> fileDetail = restTemplate.exchange(kbsUriBuilder.toString(), HttpMethod.POST, httpEntity, new ParameterizedTypeReference<net.sf.json.JSONObject>() {
        });
        log.info("Call KBS file detail result:{}", JSONObject.toJSONString(fileDetail));
        net.sf.json.JSONObject jsonObjectBody = fileDetail.getBody();
        net.sf.json.JSONObject jsonObjectBodyResponse = (net.sf.json.JSONObject) jsonObjectBody.get("response");
        if (!(boolean) jsonObjectBodyResponse.get("success")) {
            return responseData;
        }
        responseData = (net.sf.json.JSONObject) jsonObjectBodyResponse.get("data");
        return responseData;
    }
}