package com.digiwin.athena.semc.proxy.km.service;

import com.digiwin.athena.semc.dto.module.TenantModuleDto;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;

import java.util.List;

/**
 * @description km invoke
 * @author: sungqz
 * @create: 2024-02-01
 */
public interface KmService {

    /**
     * 查询当前租户购买的应用作业列表
     *
     * @return 返回对象
     */
    List<AppJobDTO> queryAppJobList();

    /**
     * 查询当前租户版本
     *
     * @return 租户版本，如：1.0、2.0
     */
    String queryTenantVersion();

    /**
     * 查询当前租户版本，若KM未返回，则默认返回2.0
     *
     * @return 租户版本，如：1.0、2.0
     */
    String queryTenantVersionWithDefault();
    /**
     * 查询当前租户购买的应用作业列表-TenantId
     *
     * @return 返回对象
     */
    List<AppJobDTO> queryAppJobListBy();


    /**
     * 根据pattern查询当前租户的应用作业列表
     *
     * @return 返回对象
     */
    List<TenantModuleDto> queryTenantModuleList(String pattern);
}
