package com.digiwin.athena.semc.proxy.km.service.impl;

import com.digiwin.athena.semc.dto.module.TenantModuleDto;
import com.google.common.collect.Lists;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.dto.BaseResultDTO;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.km.service.KmService;
import com.digiwin.athena.semc.proxy.km.service.model.AppJobDTO;
import com.digiwin.athena.semc.service.workbench.constant.EnvOperateEnum;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description km invoke
 * @author: sungqz
 * @create: 2024-02-01
 */
@Service
@Slf4j
public class KmServiceImpl implements KmService {
    @Resource
    private EnvProperties envProperties;

    @Resource
    private RestTemplate restTemplate;

    /**
     * km作业列表
     */
    private static final String QUERY_APP_JOB_PATH = "/restful/standard/datamap/record/activitiesInfoByPattern";

    /**
     * km作业列表-租户下
     */
    private static final String QUERY_APP_JOB_TENANTID_PATH = "/restful/standard/datamap/record/activitiesInfoByTenantId";


    /**
     * km租户应用作业列表
     */
    private static final String QUERY_TEMAMT_MODULE = "/restful/service/datamap/record/tenantModule";


    /**
     * 查询当前租户购买的应用作业列表
     *
     * @return 返回对象
     */
    @Override
    public List<AppJobDTO> queryAppJobList() {
        // url
        String url = envProperties.getAppmetadataUrl() + QUERY_APP_JOB_PATH;
        return getAppJobDTOS(url);
    }

    /**
     * 查询当前租户购买的应用作业列表
     *
     * @return 返回对象
     */
    @Override
    public List<AppJobDTO> queryAppJobListBy() {
        // url
        String url = envProperties.getAppmetadataUrl() + QUERY_APP_JOB_TENANTID_PATH;
        return getAppJobDTOS(url);
    }

    private List<AppJobDTO> getAppJobDTOS(String url) {

        // header
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-app", com.digiwin.athena.appcore.auth.GlobalConstant.IAM_APP_TOKEN_ATHENA);
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        // body
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(null, headers);
        ResponseEntity<JSONObject> responseEntity;
        try {
            responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class);
        } catch (Exception e) {
            log.error("query km application job list error, url:{}, request:{}", url, httpEntity, e);
            return Lists.newArrayList();
        }
        // 处理返回对象
        if (responseEntity.getStatusCodeValue() == HttpStatus.OK.value() && responseEntity.getBody() != null) {
            JSONArray data = responseEntity.getBody().getJSONArray("response");
            if (CollectionUtils.isEmpty(data)) {
                log.error("query km application job list return empty, url:{}, request:{}, response:{}", url, httpEntity, responseEntity);
                return Lists.newArrayList();
            }
            //这个日志有点大
            //log.info("query km application job list success, request:{}, result:{}", httpEntity, data);
            log.info("query km application job list success, request:{}", httpEntity);
            return JSONArray.parseArray(data.toJSONString(), AppJobDTO.class);
        } else {
            log.error("query km application job list fail, url:{}, request:{}, response:{}", url, httpEntity, responseEntity);
            return Lists.newArrayList();
        }
    }

    private static final String QUERY_TENANT_VERSION_PATH = "/restful/service/knowledgegraph/tenant/tenantVersion?tenantId={tenantId}";

    @Override
    public String queryTenantVersion() {
        String url = envProperties.getKmDomain() + QUERY_TENANT_VERSION_PATH;

        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        Map<String, Object> params = new HashMap<>();
        params.put("tenantId", tenantId);
        ResponseEntity<BaseResultDTO<String>> respEntity = restTemplate.exchange(url, HttpMethod.GET, null, new ParameterizedTypeReference<BaseResultDTO<String>>() {
        }, params);
        if (HttpStatus.OK.value() == respEntity.getStatusCodeValue() && null != respEntity.getBody() && respEntity.getBody().isOK()) {
            return respEntity.getBody().getResponse();
        }
        throw BusinessException.create("请求KM获取租户" + tenantId + "版本发生错误");
    }

    @Override
    public String queryTenantVersionWithDefault() {
        String tenantVersion = this.queryTenantVersion();
        return StringUtils.isNotBlank(tenantVersion) ? tenantVersion : EnvOperateEnum.SWITCH.getVersion();
    }

    @Override
    public List<TenantModuleDto> queryTenantModuleList(String pattern){
        // url
        String url = envProperties.getKmDomain() + QUERY_TEMAMT_MODULE + "?pattern=" + pattern;
        // header
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-app", com.digiwin.athena.appcore.auth.GlobalConstant.IAM_APP_TOKEN_ATHENA);
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        // body
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(null, headers);
        ResponseEntity<JSONObject> responseEntity;
        try {
            responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, JSONObject.class);
        } catch (Exception e) {
            log.error("query km tenant module list error, url:{}, request:{}", url, httpEntity, e);
            return Lists.newArrayList();
        }
        // 处理返回对象
        if (responseEntity.getStatusCodeValue() == HttpStatus.OK.value() && responseEntity.getBody() != null) {
            JSONArray data = responseEntity.getBody().getJSONArray("response");
            if (CollectionUtils.isEmpty(data)) {
                log.error("query km tenant module list return empty, url:{}, request:{}, response:{}", url, httpEntity, responseEntity);
                return Lists.newArrayList();
            }
            log.info("query km tenant module list success, request:{}", httpEntity);
            return JSONArray.parseArray(data.toJSONString(), TenantModuleDto.class);
        } else {
            log.error("query km tenant module list fail, url:{}, request:{}, response:{}", url, httpEntity, responseEntity);
            return Lists.newArrayList();
        }
    }
}