package com.digiwin.athena.semc.proxy.km.service.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.util.List;

/**
 * @description 应用作业对象
 * @author: sungqz
 * @create: 2024-02-01
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class AppJobDTO {

    /**
     * 应用code
     */
    private String appCode;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 作业列表
     */
    private List<Job> data;

    @Data
    public static class Job {
        /**
         * 作业code
         */
        private String code;

        /**
         * 应用code
         */
        private String appCode;

        /**
         * 作业名称
         */
        private String name;

        /**
         * 作业类型 基础资料：baseDataEntry 报表：report 发起项目：startProject
         */
        private String type;

        /**
         * 业务类别,发起项目不需要
         */
        private String category;

        /**
         * 跳转tbb报表时需要
         */
        private Boolean ifCustom;

        /**
         * 账套ID
         */
        private String accountId;

        /**
         * 账套名称
         */
        private String accountName;

    }
}
