package com.digiwin.athena.semc.proxy.maycur;

import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.PreSystemToDoReq;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import org.springframework.http.ResponseEntity;

import java.util.List;
import java.util.Map;

/**
 * 每刻对接service
 */
public interface MayCurService {


    /**
     * 获取每刻SsoToken
     *
     * @param userId    员工工号
     * @param secretKey 企业秘钥
     * @return
     */
    String getSsoToken(String userId, String secretKey,long timestamp);

    /**
     * 获取每刻首页ssourl
     * @param callback 每刻回调地址
     * @param entCode  企业Code
     * @param userId 工号
     * @param ssoToken 每刻SsoToken
     * @return
     */
    String getHomeSsoUrl(String callback, String entCode, String userId, String ssoToken,long timestamp);

    /**
     * 获取每刻云票列表ssourl
     * @param callback 每刻回调地址
     * @param entCode 企业Code
     * @param userId 工号
     * @param ssoToken 每刻SsoToken
     * @param formCategory 单据类型
     * @return
     */
    String getCloudSsoUrl(String callback, String entCode, String userId, String ssoToken, String formCategory,long timestamp);


    /**
     * 获取每刻报销列表ssourl
     * @param callback 每刻回调地址
     * @param entCode 企业Code
     * @param userId 工号
     * @param ssoToken 每刻SsoToken
     * @param url 页面地址
     * @return
     */
    String getJobSsoUrl(String callback, String entCode, String userId, String ssoToken, String url,long timestamp);

    /**
     * 替换已经存在的 url
     * @param url
     * @param entCode
     * @param userId
     * @param timestamp
     * @param ssoToken
     * @return
     */
    String getReplaceExistUrl(String url,String entCode,String userId,long timestamp,String ssoToken);


    /**
     *  获取tokenId
     * @param labelSystemDataDto
     * @param userId
     * @return
     */
    ResponseEntity<Map> getTokenId(LabelSystemDataDto labelSystemDataDto,String userId);

    /**
     *  获取每刻报销数据
     * @param tokenId
     * @param pageNum
     * @param labelSystemDataDto
     * @return
     */
    List<Map<String, Object>> listMayCurData(String tokenId, int pageNum, LabelSystemDataDto labelSystemDataDto);
}

