package com.digiwin.athena.semc.proxy.maycur.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.portal.LabelSystemDataDto;
import com.digiwin.athena.semc.dto.portal.PreSystemToDoReq;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.proxy.eoc.service.EocService;
import com.digiwin.athena.semc.proxy.maycur.MayCurService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;


@Service
@Slf4j
public class MayCurServiceImpl implements MayCurService {

    @Resource
    RestTemplate restTemplate;
    @Resource
    EocService eocService;

    /**
     * 每刻跳转url
     */
    private static final String MAYCUR_SSO_URL = "/sso?entCode=%s&userId=%s&timestamp=%s&token=%s";

    @Override
    public String getSsoToken(String userId, String secretKey,long timestamp) {
        //毫秒级时间戳
        //获取ssoToken
        String ssoToken = DigestUtils.sha256Hex((secretKey + ":" + userId + ":" + timestamp).getBytes());
        return ssoToken;
    }

    @Override
    public String getHomeSsoUrl(String callback,String entCode, String userId, String ssoToken,long timestamp) {
        callback=callback+MAYCUR_SSO_URL;
        String authUrl = String.format(callback, entCode, userId, timestamp, ssoToken);
        return authUrl;
    }

    @Override
    public String getCloudSsoUrl(String callback, String entCode, String userId, String ssoToken, String formCategory,long timestamp) {
        String jobSsoUrl = String.format(callback+MAYCUR_SSO_URL, entCode, userId, timestamp, ssoToken);
        jobSsoUrl = jobSsoUrl + "&formCategory=" + formCategory;
        return jobSsoUrl;
    }

    @Override
    public String getJobSsoUrl(String callback, String entCode, String userId, String ssoToken, String url,long timestamp) {
        String jobSsoUrl = String.format(callback+MAYCUR_SSO_URL+"&language=zh&url=%s", entCode, userId, timestamp, ssoToken,url);
        return jobSsoUrl;
    }


    @Override
    public String getReplaceExistUrl(String url, String entCode, String userId, long timestamp, String ssoToken) {
        String finalPath = url.replace("/sso?entCode={entCode}&userId={userId}&timestamp={timestamp}&token={token}",MAYCUR_SSO_URL);
        String jobSsoUrl = String.format(finalPath, entCode, userId, timestamp, ssoToken);
        return jobSsoUrl;
    }

    @Override
    public ResponseEntity<Map> getTokenId(LabelSystemDataDto labelSystemDataDto,String userId) {
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(null, new HttpHeaders());
        String authUrl = String.format(labelSystemDataDto.getCallBackUrl() + Constants.TOKENURL,
                labelSystemDataDto.getAppId(), userId, System.currentTimeMillis(), this.getSsoToken(userId,labelSystemDataDto.getAppSecret(),System.currentTimeMillis()));
        ResponseEntity<Map> response = null;
        try {
            response = restTemplate.exchange(authUrl, HttpMethod.GET, httpEntity, Map.class);
            log.info("getTokenId resp, request:{}, result:{}", authUrl, JSONObject.toJSONString(response));
        } catch (RestClientException e) {
            log.error("getTokenId error, request:{}, request:{},errorMessage:{}", authUrl, JSONObject.toJSONString(response), e.getMessage());
            return null;
        }
        return response;
    }

    @Override
    public List<Map<String, Object>> listMayCurData(String tokenId, int pageNum,LabelSystemDataDto labelSystemDataDto) {
        HttpHeaders headers  = new HttpHeaders();
        headers.set("entCode", labelSystemDataDto.getAppId());
        headers.set("tokenId",tokenId);
        HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(null, headers);
        ResponseEntity<Map> responseEntity = null;
        List<Map<String, Object>> map = new LinkedList<>();
        try {
            responseEntity = restTemplate.exchange(labelSystemDataDto.getCallBackUrl() + Constants.APPROVALURL+"&offset="+pageNum,
                    HttpMethod.GET, httpEntity, Map.class);
            if (null != responseEntity && null != responseEntity.getBody()) {
                map = (List<Map<String, Object>>) responseEntity.getBody().get("data");
                return map;
            }
            log.info("listMayCurData resp, request:{}, result:{}", JSONObject.toJSONString(httpEntity), JSONObject.toJSONString(responseEntity));
        } catch (RestClientException e) {
            log.error("listMayCurData error, request:{}, request:{},errorMessage:{}",  JSONObject.toJSONString(httpEntity), JSONObject.toJSONString(responseEntity), e.getMessage());
            return map;
        }
        return map;
    }
}