package com.digiwin.athena.semc.proxy.mdc;

import com.alibaba.excel.event.SyncReadListener;
import com.digiwin.athena.semc.proxy.mdc.model.TenantProductOperationDTO;
import com.digiwin.dap.middleware.dmc.DMC;

import java.util.List;

/**
 * @description mdc invoke
 * @author: lisheng
 * @create: 2024-6-26
 */
public interface MdcService {

    /**
     * 获取租户产品运营信息
     *
     * @return
     */
    List<TenantProductOperationDTO> getTenantProductOperationList(String tenantId, String prodName);

    /**
     * 获取dmc实例
     * @return
     */
    DMC buildDmc();

    /**
     * 获取数据
     *
     * @param listener 监听
     * @param <T>
     * @return
     */
    <T> List<T> doReadSync(SyncReadListener listener);
}