package com.digiwin.athena.semc.proxy.mdc.impl;

import com.alibaba.excel.event.SyncReadListener;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.proxy.mdc.model.TenantProductOperationDTO;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.DMCBuilder;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * MdcServiceImpl Description
 *
 * @author lisheng
 * @since 2024-6-26
 */
@Service
@Slf4j
public class MdcServiceImpl implements MdcService {

    @Resource
    private EnvProperties envProperties;

    @Resource
    private RestTemplate restTemplate;

    private static final String TENANT_PRODUCT_OPERATION_LIST_GET = "/restful/standard/mdc/TenantProductOperationList/Get";

    /**
     * 查询om平台事件及模板列表
     *
     * @return 查询om平台事件及模板列表
     */
    @Override
    public List<TenantProductOperationDTO> getTenantProductOperationList(String tenantId, String prodName) {
        // header信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", envProperties.getAppToken());

        // 请求体
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("tenant_id", tenantId);
        requestMap.put("prod_name", prodName);
        HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(requestMap, headers);
        StringBuilder url = new StringBuilder(envProperties.getMdcDomain()).append(TENANT_PRODUCT_OPERATION_LIST_GET);
        try {
            log.info("getTenantProductOperationList. param:{}", JSONObject.toJSONString(requestEntity));
            ResponseEntity<JSONObject> respEntity = restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class);
            log.info("getTenantProductOperationList response:{}", JSONObject.toJSONString(respEntity.getBody()));
            if (org.apache.http.HttpStatus.SC_OK == respEntity.getStatusCodeValue()
                    && respEntity.getBody() != null
                    && respEntity.getBody().containsKey("org_type_company")) {
                JSONArray data = respEntity.getBody().getJSONArray("org_type_company");
                return JSONArray.parseArray(data.toJSONString(), TenantProductOperationDTO.class);
            } else {
                log.info("getTenantProductOperationList return empty, userToken:{}, request:{}, url:{}, code:{}, response:{}", userToken,
                        requestMap, url, respEntity.getStatusCodeValue(), JSONObject.toJSONString(respEntity.getBody()));
                return Lists.newArrayList();
            }
        } catch (Exception ex) {
            log.error("getTenantProductOperationList error, userToken:{}, request:{}, url:{}, errorMessage:{}", userToken, requestMap, url, ex.getMessage());
            throw BusinessException.create(ex.getMessage());
        }
    }

    @Override
    public DMC buildDmc() {
        return DMCBuilder.create().build(envProperties.getDmcUri(), Constants.DMC_USER_NAME, Constants.DMC_USER, envProperties.getSemcAppId());
    }

    @Override
    public <T> List<T> doReadSync(SyncReadListener listener) {
        return (List<T>) listener.getList();
    }
}