package com.digiwin.athena.semc.proxy.trans.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.semc.dto.common.TranslateReq;

/**
 * @description DAP Translate Service
 * @author: sungqz
 * @create: 2023-8-4
 */
public interface TranslateService {

    /**
     * 文本翻译 优先取缓存
     *
     * @param text 文本
     * @param businessFlag 业务标识
     * @return
     */
    String translateTextCache(String text, String businessFlag);

    /**
     * 文本翻译
     *
     * @param text 文本
     * @return
     */
    String translateText(String text);

    /**
     * 封装的DAP文本翻译接口
     *
     * @param translateReq 入参
     * @return
     */
    JSONObject translateTextPackage(TranslateReq translateReq);
}