package com.digiwin.athena.semc.proxy.trans.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.common.TranslateReq;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.cache.ICacheService;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * DAP Translate Service
 *
 * @author sungqz
 * @date 2023/8/4
 * @since
 */
@Service
@Slf4j
public class TranslateServiceImpl implements TranslateService {

    @Resource
    private EnvProperties envProperties;

    @Resource
    private RestTemplate restTemplate;

    @Resource
    private ICacheService cacheService;

    /**
     * DAP翻译接口
     */
    private static final String DAP_TRANSLATE_PATH = "/restful/service/translater/IDWTranslateService/translate";

    /**
     * 文本翻译 优先取缓存
     *
     * @param text         文本
     * @param businessFlag 业务标识
     * @return
     */
    @Override
    public String translateTextCache(String text, String businessFlag) {
        String locale = LocaleContextHolder.getLocale().toString();
        if (StringUtils.isBlank(text) || Constants.EN_US_LOCALE.equals(locale)) {
            return text;
        }
        String textKey;
        if (Constants.ZH_CN_LOCALE.equals(locale)) {
            textKey = Constants.TEXT_CN_CACHE_KEY + businessFlag + text;
        } else {
            textKey = Constants.TEXT_TW_CACHE_KEY + businessFlag + text;
        }
        String translateText = null;
        try {
            Object cache = cacheService.get(textKey);
            if (Objects.nonNull(cache)) {
                return String.valueOf(cache);
            }
            translateText = translateText(text);
            if (StringUtils.isNotBlank(translateText)) {
                cacheService.cache(textKey, translateText, Duration.ofHours(24));
            }
        } catch (Exception e) {
            log.error("translateTextCache exception", e);
            return text;
        }
        return translateText;
    }

    /**
     * 文本翻译
     *
     * @param text 文本
     * @return
     */
    @Override
    public String translateText(String text) {
        //敏数私有化翻译服务不下地，直接返回
        return text;
//        String locale = LocaleContextHolder.getLocale().toString();
//        if (StringUtils.isBlank(text) || Constants.EN_US_LOCALE.equals(locale)) {
//            return text;
//        }
//        HttpHeaders headers = new HttpHeaders();
//        headers.setContentType(MediaType.APPLICATION_JSON);
//        // 请求体
//        Map<String, Object> requestMap = new HashMap<>();
//        requestMap.put("content", text);
//
//        // 英文不翻译
//        if (Constants.ZH_CN_LOCALE.equals(locale)) {
//            requestMap.put("convertTypes", Collections.singletonList(Constants.TRANSLATE_TW_TO_CN));
//        } else {
//            requestMap.put("convertTypes", Collections.singletonList(Constants.TRANSLATE_CN_TO_TW));
//        }
//        HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(requestMap, headers);
//        StringBuilder url = new StringBuilder(envProperties.getTransUri()).append(DAP_TRANSLATE_PATH);
//        try {
//            ResponseEntity<JSONObject> respEntity = restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class);
//            if (org.apache.http.HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
//                JSONObject data = respEntity.getBody().getJSONObject("response").getJSONObject("data");
//                if (Objects.nonNull(data)) {
//                    return Constants.ZH_CN_LOCALE.equals(locale) ? data.getString(Constants.TRANSLATE_TW_TO_CN) : data.getString(Constants.TRANSLATE_CN_TO_TW);
//                } else {
//                    log.error("translate text return empty, url:{}, text:{}", url, text);
//                    return null;
//                }
//            } else {
//                log.error("translate text fail, url:{}, status:{}, response:{}", url, respEntity.getStatusCodeValue(), JSONObject.toJSONString(respEntity.getBody()));
//                return null;
//            }
//        } catch (Exception ex) {
//            log.error("translate text error, url:{}, errorMessage:{}", url, ex.getMessage());
//            throw BusinessException.create(ex.getMessage());
//        }
    }

    /**
     * 封装的DAP文本翻译接口
     *
     * @param translateReq 入参
     * @return
     */
    @Override
    public JSONObject translateTextPackage(TranslateReq translateReq) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        // 请求体
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("content", translateReq.getContent());
        requestMap.put("convertTypes", translateReq.getConvertTypes());
        HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(requestMap, headers);
        StringBuilder url = new StringBuilder(envProperties.getTransUri()).append(DAP_TRANSLATE_PATH);
        try {
            ResponseEntity<JSONObject> respEntity = restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class);
            if (org.apache.http.HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                return respEntity.getBody().getJSONObject("response");
            } else {
                log.error("translateTextPackage | translate text fail, url:{}, status:{}, response:{}", url, respEntity.getStatusCodeValue(), JSONObject.toJSONString(respEntity.getBody()));
                return null;
            }
        } catch (Exception ex) {
            log.error("translateTextPackage | translate text package error, url:{}, requestEntity:{}, errorMessage:{}", url, requestEntity, ex.getMessage());
            throw BusinessException.create(ex.getMessage());
        }
    }
}