package com.digiwin.athena.semc.proxy.tripartite.service;


import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.semc.dto.portal.LabelSystemPreReq;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;

import java.util.List;
import java.util.Map;

/**
 * 非混合云方式请求三方系统相关接口
 */
public interface TripartiteService {

    /**
     * 请求第三方接口
     *
     * @param url       接口url
     * @param bodyParam body的json入参
     * @return
     */
    Map<String, Object> selectDataPagePost(String url, LabelSystemPreReq bodyParam, String appToken);

    /**
     * 查询三方应用统计类型数据
     *
     * @param countCode 统计分类
     * @param contentCodeList 统计分类下类型
     * @param url 请求url
     * @param locale 语系
     * @return 返回
     */
    Map<String, Object> selectDataCountListPost(String countCode, List<String> contentCodeList, String url, String locale);

    /**
     * 查询异构系统消息
     *
     * @param url      请求url
     * @param pageNo   当前页
     * @param pageSize 页大
     * @return
     */
    Map<String, Object> queryThirdMessageDataPage(String url, Integer pageNo, Integer pageSize);


    JSONArray queryThirdData(String url, String appToken);

    Map<String, Object> queryThirdData(String url, String appToken, Map<String, Object> bodyMap);

    /**
     * 查询三方应用业务待办类型
     *
     * @param restUrl 请求地址
     * @return 返回
     */
    Map<String, Object> queryThirdBusinessTodoGroupList(String restUrl);

    /**
     * 查询三方应用业务待办数量
     *
     * @param labelSystemData 请求参数
     * @param appToken 应用appToken
     * @return 返回
     */
    Map<String, Object> queryThirdBusinessTodoValueList(LabelSystemData labelSystemData, String appToken);
}