package com.digiwin.athena.semc.proxywrapper;


import com.digiwin.athena.semc.proxywrapper.dto.IamUserAuthInfo;

import java.util.List;

import io.vavr.Tuple3;

public interface IamUserService {

    /**
     * 获取iam用户权限信息
     * @param userId
     * @param userToken
     * @return
     */
    Tuple3<List<Long>, List<Long>, List<Long>> getUserAuthInfo(String userId, String userToken);


    /**
     * 获取iam用户权限信息sid集合
     * @param userId
     * @param userToken
     * @return
     */
    IamUserAuthInfo getUserAuthSids(String userId, String tenantId,String userToken);

    /**
     * 删除iam用户权限信息sid集合
     *
     * @param userId 用户id
     * @param tenantId 租户id
     */
    void removeUserAuthInfo(String userId, String tenantId);

    /**
     * 删除是否是超管标识缓存
     *
     * @param tenantId 租户id
     * @param userId 用户id
     */
    void removeSuperAdminFlagCache(String tenantId, String userId);
}
