package com.digiwin.athena.semc.quartz;

import com.digiwin.athena.appcore.util.SpringUtil;

import org.quartz.utils.ConnectionProvider;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

/**
 * @Author xuzd
 * @Date 2024/5/17 12:25
 * @Description: druid连接池配置
 */
public class DruidPoolingconnectionProvider implements ConnectionProvider {

    private DataSource dataSource;

    @Override
    public void initialize() throws SQLException {
        // 从 Spring 容器中获取 Druid 数据源
        this.dataSource = SpringUtil.getBean(DataSource.class);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return dataSource.getConnection();
    }

    @Override
    public void shutdown() {
        // Druid 数据源的关闭由 Spring 管理，此处无需操作
    }

}
