package com.digiwin.athena.semc.quartz;


import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.dto.PageInfo;
import com.digiwin.athena.semc.dto.mq.MessageDO;
import com.digiwin.athena.semc.entity.portal.TodoField;
import com.digiwin.athena.semc.entity.portal.TodoList;
import com.digiwin.athena.semc.entity.portal.TodoRead;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.portal.TodoFieldMapper;
import com.digiwin.athena.semc.mapper.portal.TodoListMapper;
import com.digiwin.athena.semc.mapper.portal.TodoReadMapper;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.mq.MessageSendService;
import com.digiwin.athena.semc.service.portal.LabelSystemDataService;
import com.digiwin.athena.semc.service.portal.TodoFieldService;
import com.digiwin.athena.semc.service.portal.TodoListService;
import com.digiwin.athena.semc.util.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author xuzd
 * @Date 2024/5/9 15:43
 * @Description: 第三方待办拉取定时任务
 */
@Component
@Slf4j
public class ThirdTodoPullTaskJob extends QuartzJobBean {


    @Resource
    private SchedulerFactoryBean schedulerFactoryBean;


    @Autowired
    private ESPService espService;

    @Autowired
    private TripartiteService tripartiteService;

    @Autowired
    private TodoListMapper todoListMapper;

    @Autowired
    private TodoListService todoListService;

    @Autowired
    private TodoFieldMapper todoFieldMapper;

    @Autowired
    private TodoFieldService todoFieldService;

    @Autowired
    private MessageSendService messageSendService;

    @Autowired
    private TodoReadMapper todoReadMapper;


    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        try {
            //拉取的所有待插入待办数据
            List<Map<String, Object>> todoLists = new ArrayList<>();
            //拉取的待办标题数据
            List<Map<String, Object>> todoFieldList = new ArrayList<>();
            Map<String, Object> params = (Map<String, Object>) context.getJobDetail().getJobDataMap().get("params");
            Integer appAccessModel = (Integer) params.get("appAccessModel");

            String id = ObjectUtils.isNotEmpty(params.get("id")) ? params.get("id").toString() : "";
            String appId = ObjectUtils.isNotEmpty(params.get("appId")) ? params.get("appId").toString() : "";
            String appIdCode = ObjectUtils.isNotEmpty(params.get("appIdCode")) ? params.get("appIdCode").toString() : "";
            String tenantsid = ObjectUtils.isNotEmpty(params.get("tenantsid")) ? params.get("tenantsid").toString() : "";
            log.info("ThirdTodoPullTaskJob start. appIdCode:{}, appId:{}", appIdCode, appId);
            //混合云
            if (appAccessModel == 0) {
                AuthoredUser athenaUser = new AuthoredUser();
                athenaUser.setTenantId(tenantsid);
                AppAuthContextHolder.getContext().setAuthoredUser(athenaUser);
                //默认设置中文简体
                LocaleContextHolder.setLocale(Locale.SIMPLIFIED_CHINESE);
                String middleSystemName = params.get("middleSystemName").toString();
                String middleSystemUid = params.get("middleSystemUid").toString();
                Map<String, String> extHeader = new HashMap<>();
                extHeader.put("digi-userToken", "");
                extHeader.put("digi-appToken", "");
                // 通过ESP查询三方系统的待办数据
                for (int i = 1; ; i++) {
                    Map<String, Object> parameter = new HashMap<>();
                    parameter.put("page_no", i);
                    parameter.put("page_size", Constants.TODO_MAX_SIZE);
                    parameter.put("tenant_id", tenantsid);
                    Map<String, Object> result = espService.queryByEsp(middleSystemName,
                            middleSystemUid, EAIServiceNameEnum.TO_DO_LIST_QUERY.getServiceName(), extHeader, parameter, null, null
                    );
                    // 没有显示字段时，返回异常
                    if (Objects.isNull(result.get("to_do_list"))) {
                        log.info("ThirdTodoPullTaskJob 混合云未查询到待办数据");
                        break;
                    }
                    //每次拉取的待插入待办数据
                    List<Map<String, Object>> todoList = (List<Map<String, Object>>) result.get("to_do_list");
                    todoFieldList = (List<Map<String, Object>>) result.get("display_field_list");
                    log.info("ThirdTodoPullTaskJob  混合云待办数据:{}", todoList);
                    //插入待办数据
                    if (CollectionUtils.isNotEmpty(todoList) && CollectionUtils.isNotEmpty(todoFieldList)) {
                        todoLists.addAll(todoList);

                    }
                    log.info("ThirdTodoPullTaskJob 混合云待办任务" + id + "执行成功！");
                    if (!(Boolean) result.get("has_next")) {
                        break;
                    }
                }

            }
            //非混合云
            if (appAccessModel == 1) {
                for (int i = 1; ; i++) {
                    String domain = params.get("domain").toString();
                    Map<String, Object> bodyMap = new HashMap<>();
                    bodyMap.put("page_no", i);
                    bodyMap.put("page_size", Constants.TODO_MAX_SIZE);
                    bodyMap.put("tenant_id", tenantsid);
                    Map<String, Object> jobData = tripartiteService.queryThirdData(domain + Constants.QUERY_TODOJOB_LIST_URL, "", bodyMap);
//                    Map<String, Object> jobData = tripartiteService.queryThirdData(domain +  "/eai/mocksys/todo/queryToDoData", "", bodyMap);
                    if (null == jobData) {
                        log.info("ThirdTodoPullTaskJob 非混合云未查询到待办数据");
                        break;
                    }
                    //每次拉取的待插入待办数据
                    List<Map<String, Object>> todoList = (List<Map<String, Object>>) jobData.get("to_do_list");
                    todoFieldList = (List<Map<String, Object>>) jobData.get("display_field_list");
                    log.info("ThirdTodoPullTaskJob 非混合云待办数据:{}", todoList);
                    //插入待办数据
                    if (CollectionUtils.isNotEmpty(todoList) && CollectionUtils.isNotEmpty(todoFieldList)) {
                        todoLists.addAll(todoList);
                    }
                    log.info("ThirdTodoPullTaskJob 非混合云待办任务" + id + "执行成功！");
                    if (!(Boolean) jobData.get("has_next")) {
                        break;
                    }
                }
            }
            //处理待办数据
            handleTodoData(todoLists, todoFieldList, appId, appIdCode);
            //删除read数据
            List<TodoRead> todoReadList = todoReadMapper.selectList(getToDoReadWrapepr(appId));
            if (CollectionUtils.isNotEmpty(todoReadList) && CollectionUtils.isNotEmpty(todoLists)) {
                for (TodoRead todoRead : todoReadList) {
                    List<Map<String, Object>> result = todoLists.stream().filter(it -> it.get("to_do_id").toString().equals(todoRead.getToDoId())
                            && it.get("to_do_owner").toString().equals(todoRead.getToDoUser())).collect(Collectors.toList());
                    if (result.size() == 0) {
                        QueryWrapper deleteWrapper = new QueryWrapper<TodoRead>();
                        deleteWrapper.eq("app_id", appId);
                        deleteWrapper.eq("to_do_id", todoRead.getToDoId());
                        deleteWrapper.eq("to_do_user", todoRead.getToDoUser());
                        todoReadMapper.delete(deleteWrapper);
                    }
                }
            }
        } catch (Exception e) {
            log.error("ThirdTodoPullTaskJob error  e:{}", e);
        }
    }


    /**
     * @Author xuzd
     * @Date 2024/5/9 17:52
     * @Description: 添加定时任务
     */
    public void addJob(Map<String, Object> params) {
        try {
            String id = params.get("id").toString();
            Integer pullPeriod = (Integer) params.get("pullPeriod");
            //pullPeriod=pullPeriod*3600;
            //1:创建调度器
            Scheduler scheduler = schedulerFactoryBean.getScheduler();
            //2:创建任务实例
            JobDetail jobDetail = JobBuilder.newJob(ThirdTodoPullTaskJob.class).
                    withIdentity("ThirdTodoPullTaskJob", "TodoJob_" + id).storeDurably(true).
                    build();
            //设置参数，在定时任务执行时可以动态获取这些参数
            jobDetail.getJobDataMap().put("params", params);
            //3:创建触发器Trigger
            Trigger trigger = TriggerBuilder.newTrigger().
                    withIdentity("ThirdTodoPullTaskJob", "TodoTrigger_" + id).
                    withSchedule(SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(pullPeriod).repeatForever()).
                    build();
            //4:触发器和任务关联
            scheduler.scheduleJob(jobDetail, trigger);
            //5:启动任务调度器
            scheduler.start();
        } catch (SchedulerException e) {
            e.printStackTrace();
        }
    }


    /**
     * @Author xuzd
     * @Date 2024/5/10 9:59
     * @Description: 暂停定时任务
     */
    public void pauseJob(String name, String group) throws SchedulerException {
        Scheduler scheduler = schedulerFactoryBean.getScheduler();
        JobKey jobKey = new JobKey(name, group);
        JobDetail jobDetail = scheduler.getJobDetail(jobKey);
        if (jobDetail == null) {
            return;
        }
        scheduler.pauseJob(jobKey);
    }


    /**
     * @Author xuzd
     * @Date 2024/5/10 10:01
     * @Description: 恢复定时任务
     */
    public void resumeJob(String name, String group) throws SchedulerException {
        Scheduler scheduler = schedulerFactoryBean.getScheduler();
        JobKey jobKey = new JobKey(name, group);
        JobDetail jobDetail = scheduler.getJobDetail(jobKey);
        if (jobDetail == null) {
            return;
        }
        scheduler.resumeJob(jobKey);
    }


    /**
     * @Author xuzd
     * @Date 2024/5/10 10:02
     * @Description: 删除定时任务
     */
    public void deleteJob(String name, String group) throws Exception {
        Scheduler scheduler = schedulerFactoryBean.getScheduler();
        JobKey jobKey = new JobKey(name, group);
        JobDetail jobDetail = scheduler.getJobDetail(jobKey);
        if (jobDetail == null) {
            return;
        }
        scheduler.deleteJob(jobKey);
    }

    /**
     * 获取查询待办数据QueryWrapper
     *
     * @return
     */
    public QueryWrapper getToDoWrapepr(String appId, List<TodoList> todoListDtos) {
        QueryWrapper queryWrapper = new QueryWrapper<TodoList>();
        //应用查询
        if (StringUtils.isNotEmpty(appId)) {
            queryWrapper.eq("app_id", appId);
        }
        /*// 账套id
        List<String> accountIdList = todoListDtos.stream().map(TodoList::getAccountId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(accountIdList)){
            queryWrapper.in("account_id", accountIdList);
        }*/
        return queryWrapper;
    }


    public QueryWrapper getToDoReadWrapepr(String appId) {
        QueryWrapper queryWrapper = new QueryWrapper<TodoRead>();
        //应用查询
        if (StringUtils.isNotEmpty(appId)) {
            queryWrapper.eq("app_id", appId);
        }
        return queryWrapper;
    }

    /**
     * @Author xuzd
     * @Date 2024/5/13 11:31
     * @Description: 待办数据处理
     *//* for(Map<String,Object>map:todoList){
            String todoId=map.get("to_do_id").toString();
        }*/
    public void handleTodoData(List<Map<String, Object>> todoList, List<Map<String, Object>> todoFieldList, String appId, String appIdCode) {
        List<TodoList> todoListDtos = new ArrayList<>();
        List<TodoField> todoFieldListDtos = new ArrayList<>();
        List<String> todoUserList = new ArrayList<>();
        for (Map<String, Object> map : todoList) {
            TodoList todo = new TodoList();
            String todoId = map.get("to_do_id").toString();
            String todoUser = map.get("to_do_owner").toString();
            String accountId = MapUtils.getString(map, "account_id");
            if (StringUtils.isEmpty(todoId) || StringUtils.isEmpty(todoUser)) {
                continue;
            }
            todo.setToDoSource(2);
            todo.setAppName("");
            todo.setAppId(appId);
            todo.setAppIdCode(appIdCode);
            if(StringUtils.isNotBlank(accountId)){
                todo.setAccountId(accountId);
                todo.setAccountName(MapUtils.getString(map, "account_name"));
            }
            todo.setToDoId(todoId);
            String toDoUrl = map.get("to_do_url") == null ? "" : map.get("to_do_url").toString();
            todo.setToDoUrl(toDoUrl);
            String mobileUrl = map.get("to_do_mobile_url") == null ? "" : map.get("to_do_mobile_url").toString();
            todo.setMobileUrl(mobileUrl);
            todo.setToDoUser(todoUser);
            String toDoData = map.get("to_do_data") == null ? "" : map.get("to_do_data").toString();
            todo.setToDoData(toDoData);
            todo.setIsCompleted(0);
            todo.setIsRead(0);
            String mobileMainTitle = map.get("mobile_main_title") == null ? "" : map.get("mobile_main_title").toString();
            todo.setMobileMainTitle(mobileMainTitle);
            String mobileSubTitle = map.get("mobile_sub_title") == null ? "" : map.get("mobile_sub_title").toString();
            todo.setMobileSubTitle(mobileSubTitle);
            String mobileLabel = map.get("mobile_label") == null ? "" : map.get("mobile_label").toString();
            todo.setMobileLabel(mobileLabel);
            todo.setTenantId("");
            todo.setCreateTime(DateUtils.getNowTime(DateUtils.DATE_TIME_NORMAL_FORMATTER));
            //todoListMapper.delete(getToDoWrapepr(appId, todoId));
            todoListDtos.add(todo);
            if (!todoUserList.contains(todoUser)) {
                todoUserList.add(todoUser);
            }
        }
        //保存待办标题
        for (Map<String, Object> fieldmap : todoFieldList) {
            TodoField field = new TodoField();
            field.setAppId(appId);
            String displayName = fieldmap.get("display_name") == null ? "" : fieldmap.get("display_name").toString();
            field.setDisplayName(displayName);
            Integer displayOrder = fieldmap.get("display_order") == null ? null : Integer.parseInt(fieldmap.get("display_order").toString());
            field.setDisplayOrder(displayOrder);
            String bindingDataKey = fieldmap.get("binding_data_key") == null ? "" : fieldmap.get("binding_data_key").toString();
            field.setBindingDataKey(bindingDataKey);
            field.setCreateTime(DateUtils.getNowTime(DateUtils.DATE_TIME_NORMAL_FORMATTER));
            todoFieldListDtos.add(field);
        }
        //删除待办数据
        todoListMapper.delete(getToDoWrapepr(appId, todoListDtos));
        //保存待办数据
        if (CollectionUtils.isNotEmpty(todoListDtos)) {
            //超过1000笔分批插入
            if (todoListDtos.size() > 1000) {
                for (int i = 0; i < todoListDtos.size(); i += 1000) {
                    List<TodoList> batchEntities = todoListDtos.subList(i, Math.min(i + 1000, todoListDtos.size()));
                    todoListService.saveBatch(batchEntities);
                }
            } else {
                todoListService.saveBatch(todoListDtos);
            }
        }
        //保存待办标题
        if (CollectionUtils.isNotEmpty(todoFieldListDtos)) {
            //删除该应用展示的标题数据
            QueryWrapper delFieldWrapper = new QueryWrapper<TodoField>();
            //应用查询
            delFieldWrapper.eq("app_id", appId);
            todoFieldMapper.delete(delFieldWrapper);
            todoFieldService.saveBatch(todoFieldListDtos);
        }
        //推送通知给PC用户
        pushToUser(appId, todoUserList);
    }

    /**
     * 推送通知给PC用户
     *
     * @param appCode          应用id，sso配置中的appid
     * @param verifyUserldList 地端用户id
     */
    public void pushToUser(String appCode, List<String> verifyUserldList) {
        //给PC通知更新
        for (String verifyUserld : verifyUserldList) {
            try {
                MessageDO payload = new MessageDO();
                payload.setAppId(appCode);
                payload.setUserId(verifyUserld);
                payload.setType(Constants.VALID_STATUS_UNUSABLE);
                messageSendService.sendToClient(verifyUserld, payload, Constants.SEMC_TODO_USER);
            } catch (Exception e) {
                log.info("【pushToUser-sendToClient发送MQTT异常】verifyUserld：{},error：{}", verifyUserld, e);
                continue;
            }
        }
    }

}
