package com.digiwin.athena.semc.service.applink;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.semc.dto.erpsso.GetSsoUrlReq;
import com.digiwin.athena.semc.dto.erpsso.GetSsoUrlResp;
import com.digiwin.athena.semc.dto.erpsso.QueryDisplayReq;
import com.digiwin.athena.semc.entity.applink.AppLinkDTO;
import com.digiwin.athena.semc.entity.applink.AppLinkGroupDTO;
import com.digiwin.athena.semc.entity.applink.AppLinkListDTO;
import com.digiwin.athena.semc.entity.common.BizObjCommonUse;

import java.util.List;
import java.util.Map;

/**
 * 友情链接
 *
 * @date 2022/12/23
 */
public interface AppLinkService {
    /**
     * 记录一次访问友情链接的操作
     *
     * @param appId 应用Id
     */
    void accessLink(String appId);

    /**
     * 返回友情链接的列表
     * 链接数量1-9个时，则直接罗列呈现
     * 10-20个时，额外呈现用户最近点击使用过的3个链接地址
     * 20个+时，则补充增加链接分组能力，待PO规划
     *
     * @return 友情链接的列表
     */
    AppLinkListDTO queryLinkList(AuthoredUser user);

    /**
     * 获取租户权限下所有的应用
     *
     * @param user
     * @return
     */
    List<AppLinkGroupDTO> getAppLinkList(AuthoredUser user);

    /**
     * 首页，查询友情链接全部应用列表，返回当前登录用户权限内可查看的列表
     *
     * @param user
     * @return
     */
    List<AppLinkDTO> queryDisplayList(AuthoredUser user);

    /**
     * TBB报表支持串查ERP报表
     *
     * @param user
     * @param req
     * @return
     */
    AppLinkDTO queryDisplay(AuthoredUser user, QueryDisplayReq req) throws Exception;

    /**
     * 首页友情链接，通过应用id查询应用信息列表
     *
     * @param commonUseList 常用列表id
     * @return
     */
    List<AppLinkDTO> queryCommonList(List<BizObjCommonUse> commonUseList, AuthoredUser user);

    /**
     * 管理后台，查询所有b/s应用、c/s应用、预设应用
     *
     * @param user
     * @return
     */
    List<AppLinkDTO> queryManageList(AuthoredUser user);

    /**
     * 管理后台，根据权限id查询有权限的应用列表
     *
     * @param authId 权限id
     * @return
     */
    List<AppLinkDTO> queryAuthorizedList(String authId);

    /**
     * 查询预设应用列表，组装SSO链接
     *
     * @param user 用户信息
     * @return
     */
    List<AppLinkDTO> queryPerInstallAppGroup(AuthoredUser user);

    /**
     * 查询雅典娜应用列表
     *
     * @return
     */
    List<AppLinkDTO> queryDefaultGroup(AuthoredUser user);

    /**
     * 获取友情链接sso
     *
     * @param req
     * @return
     */
    AppLinkDTO getLinkSsoUrl(AppLinkDTO req);

    /**
     * 查询管理后台，查询所有b/s应用、c/s应用、预设应用
     *
     * @param user
     * @return
     */
    List<AppLinkDTO> querySsoList(AuthoredUser user);


    /**
     * 查询app 异步
     *
     * @param user
     * @return
     */
    List<AppLinkDTO> queryManageListSync(AuthoredUser user);


    /**
     * 异步查询移动端+IAM应用列表
     *
     * @param user 用户信息
     * @return 返回
     */
    List<AppLinkDTO> queryMobileManageListSync(AuthoredUser user);

    /**
     * 构建应用跳转的完整链接
     *
     * @param url        应用返回的链接
     * @param appLinkDTO 应用信息
     * @return 返回
     */
    String parseJumpUrl(String url, AppLinkDTO appLinkDTO);

    /**
     * 管理后台，根据权限id查询所有有权限的应用列表
     *
     * @param authId 权限id
     * @return
     */
    List<AppLinkDTO> queryAllAuthorizedList(String authId);

    /**
     * 拼接SSO路径
     * @param callBackUrl
     * @param appId
     * @param appToken
     * @param primaryId
     * @param code
     * @param name
     * @param desc
     * @param ext
     * @param type
     * @param protocolType
     * @param casServerUrl
     * @param userBindFlag
     * @return
     */
    AppLinkDTO buildAppLinkDTO(String callBackUrl, String appId, String appToken, Long primaryId, String code, String name, String desc, Map<String, Object> ext, Integer type, Integer protocolType, String casServerUrl, Integer userBindFlag);

    /**
     * 查询管理后台，查询所有b/s应用、c/s应用、预设应用
     *
     * @param req
     * @return
     */
    GetSsoUrlResp getSsoUrl(GetSsoUrlReq req);

    /**
     * 根据应用来源和应用主键id查询应用信息
     *
     * @param dataType     应用来源
     * @param appPrimaryId 应用主键id
     * @param user 用户信息
     * @return 返回
     */
    AppLinkDTO queryApplicationByDataType(Integer dataType, String appPrimaryId, AuthoredUser user);

    /**
     * 查询sso配置列表
     *
     * @param appIdList appId
     * @return 返回
     */
    List<AppLinkDTO> querySsoConfigListSync(List<String> appIdList);
}

