package com.digiwin.athena.semc.service.bench;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.bench.JobBench;
import com.digiwin.athena.semc.entity.bench.JobBenchCustom;
import com.digiwin.athena.semc.entity.bench.JobBenchImport;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.vo.bench.*;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;

import java.util.List;


public interface JobBenchService extends IService<JobBench> {


    /**
     * 查询所有工作台、泳道、作业
     * @return
     */
    List<JobBench> queryAllBench(List<Long> customIdList,List<Long> allSystemIdList);

    /**
     * 查询模版中所有工作台
     * @return
     */
    List<JobBench> queryTempBenchList();




    /**
     * 查询权限内工作台、泳道、作业
     * @return
     */
    List<JobBench> queryAuthAllBench(List<Long> customIdList);

    /**
     * 保存工作台
     * @param jobBench
     * @return
     */
    Long saveBench(JobBench jobBench);

    /**
     * 查询工作台/泳道的名称是否存在
     * @return
     */
    List<JobBench> selectByName(JobBench req);

    /**
     * 保存作业工作台中的组件信息
     * @param saveVO
     * @return
     */
    Integer saveJobList(JobBenchSaveVO saveVO);


    /**
     * 查询工作台和组件关系是否存在
     * @return
     */
    List<JobBenchCustom> selectBySystem(JobBenchSaveVO req);


    /**
     * 删除泳道下的作业
     * @param saveVO
     * @return
     */
    Integer delLaneJob(JobBenchSaveVO saveVO);

    /**
     * 删除工作台/泳道接口
     * @param id 工作台/泳道id
     * @return
     */
    Integer delBeanLane(Long id);


    /**
     * 工作台/泳道排序接口
     * @return
     */
    Integer orderBenchLane(OrderBenchLaneVO req);

    /**
     * 泳道下组件排序接口
     * @return
     */
    Integer orderLaneJob(OrderLaneJobVO req);


    /**
     * 导入作业工作台--读取excel数据
     * @param fileId
     * @return
     */
    List<JobBenchImportVo> readExcel(String fileId);


    /**
     * 导入作业工作台
     * @param jobBenchImportVoList
     * @return
     */
    ImportExcelResp importReport(List<JobBenchImportVo> jobBenchImportVoList);

    /**
     * 查询作业工作台记录
     * @param queryImportRecordReq
     * @return
     */
    PageInfoResp<JobBenchImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq);


    /**
     * 导出作业工作台
     * @return
     */
    List<JobBenchExportVo> exportReport();



}