package com.digiwin.athena.semc.service.bench;


import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.dto.portal.JobSyncReq;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;

import java.util.List;


public interface SyncJobInfoService extends IService<SyncJobInfo> {


    /**
     * 作业同步保存
     * @param req
     * @return
     */
    Integer  jobSyncSave(JobSyncReq req);

    /**
     * 作业同步历史保存
     * @param req
     * @return
     */
    Integer  jobSyncHistorySave(JobSyncReq req,Integer syncStatus,String resp);


    /**
     * 查询应用下作业
     * @param appId
     * @return
     */
    List<SyncJobInfo> selectJobList(String appId, List<String> accountIdList);


    /**
     * 查询已集成作业的应用appId
     * @return
     */
    List<String> getJobAppIdList(List<String> appIdList);

}