package com.digiwin.athena.semc.service.bench;


import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.message.DeleteMessageConfigReq;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageConfigReq;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.bench.ThirdJobConfig;

import java.util.List;


public interface ThirdJobConfigService extends IService<ThirdJobConfig> {

    /**
     * 保存/编辑作业配置
     * @param req
     * @return
     */
    Integer saveThirdJob(ThirdJobConfig req);



    /**
     * 删除作业配置
     * @param req
     * @return
     */
    Integer delThirdJob(DeleteMessageConfigReq req);



    /**
     * 查询异构系统的作业配置
     *
     * @param queryImportRecordReq 查询参数
     * @return
     */
    PageInfoResp<ThirdJobConfig> queryConfigPage(QueryThirdMessageConfigReq queryImportRecordReq);



    /**
     * 校验应用是否已经存在
     *
     * @param req 请求入参
     * @return
     */
    boolean validJobConfigExist(ThirdJobConfig req);


    /**
     * 从三方系统主动拉取菜单
     * @param appPrimaryId
     * @param appSource
     * @return
     */
    List<SyncJobInfo> getThirdJobList(String appPrimaryId,Integer appSource,String appToken,String appId,String appIdCode);

    /**
     * 查询应用配置信息
     * @param appCode 应用编码
     * @param appId 应用注册时生成的appId
     * @return
     */
    ThirdJobConfig getJobConfigBy(String appCode,String appId);
}