package com.digiwin.athena.semc.service.bench.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.event.SyncReadListener;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.dto.portal.QueryImportRecordReq;
import com.digiwin.athena.semc.entity.bench.JobBench;
import com.digiwin.athena.semc.entity.bench.JobBenchCustom;
import com.digiwin.athena.semc.entity.bench.JobBenchImport;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.bench.JobBenchCustomMapper;
import com.digiwin.athena.semc.mapper.bench.JobBenchImportMapper;
import com.digiwin.athena.semc.mapper.bench.JobBenchMapper;
import com.digiwin.athena.semc.mapper.portal.LabelSystemDataMapper;
import com.digiwin.athena.semc.proxy.mdc.MdcService;
import com.digiwin.athena.semc.proxy.trans.service.TranslateService;
import com.digiwin.athena.semc.service.bench.JobBenchService;
import com.digiwin.athena.semc.service.mobile.MobileUserAuthService;
import com.digiwin.athena.semc.service.portal.IImportRecordService;
import com.digiwin.athena.semc.service.portal.LabelSystemCustomService;
import com.digiwin.athena.semc.util.DateUtils;
import com.digiwin.athena.semc.util.Utils;
import com.digiwin.athena.semc.vo.bench.JobBenchExportVo;
import com.digiwin.athena.semc.vo.bench.JobBenchImportVo;
import com.digiwin.athena.semc.vo.bench.JobBenchSaveVO;
import com.digiwin.athena.semc.vo.bench.OrderBenchLaneVO;
import com.digiwin.athena.semc.vo.bench.OrderLaneJobVO;
import com.digiwin.athena.semc.vo.common.UserAuthSystemLabelVo;
import com.digiwin.athena.semc.vo.portal.ImportExcelResp;
import com.digiwin.athena.semc.vo.portal.LabelSystemAllVo;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;


@Slf4j
@Service
public class JobBenchServiceImpl extends ServiceImpl<JobBenchMapper, JobBench> implements JobBenchService {

    @Autowired
    JobBenchMapper jobBenchMapper;

    @Autowired
    JobBenchCustomMapper jobBenchCustomMapper;

    @Resource
    private TranslateService translateService;

    @Resource
    private EnvProperties envProperties;

    @Autowired
    MdcService mdcService;

    @Autowired
    private LabelSystemCustomService labelSystemCustomService;

    @Resource
    private IImportRecordService importRecordService;

    @Resource
    private JobBenchImportMapper jobBenchImportMapper;


    @Resource
    MobileUserAuthService mobileUserAuthService;

    @Resource
    LabelSystemDataMapper labelSystemDataMapper;

    /**
     * 获取工作台数据
     *
     * @param req
     * @return
     */
    public List<JobBench> getBenchList(JobBench req) {
        List<JobBench> jobBenchList = selectByName(req);
        return jobBenchList;
    }


    @Override
    public List<JobBench> queryAllBench(List<Long> customIdList,List<Long> allSystemIdList) {
        JobBench req = new JobBench();
        //查询所有一级工作台
        req.setParentId(0L);
        List<JobBench> jobBenchList = getBenchList(req);
        if (CollectionUtils.isEmpty(jobBenchList)) {
            return new ArrayList<JobBench>();
        }
        //循环查询泳道和组件信息
        for (JobBench jobBench : jobBenchList) {
            getBenchChild(jobBench, customIdList,allSystemIdList);
        }
        return jobBenchList;
    }

    @Override
    public List<JobBench> queryTempBenchList() {
        List<Long> parentIdList = new ArrayList<>();
        parentIdList.add(0L);
        return jobBenchMapper.selectBenchByTemp(parentIdList, null);
    }

    @Override
    public List<JobBench> queryAuthAllBench(List<Long> customIdList) {
        // 查询所有业务待办组件，该类型的组件默认都有权限
        LabelSystemAllVo req = new LabelSystemAllVo();
        req.setDataCategoryList(Collections.singletonList(Constants.DataCategoryEnum.BUSINESS_TODO.getVal()));
        List<LabelSystemCustom> systemCustomList = labelSystemCustomService.queryCustomSystem(req);
        //业务待办组件ID集合
        List<Long> businessTodoIdList = systemCustomList.stream().map(LabelSystemCustom::getId).collect(Collectors.toList());
        customIdList.addAll(businessTodoIdList);
        //组件中的数据源ID集合
        List<Long> allBenchSystemIdList=new ArrayList<>();
        //查询权限内的工作台和作业组件
        List<JobBench> jobBenchList = queryAllBench(null,allBenchSystemIdList);
        //查询 源应用为[鼎捷雅典娜APP ] 且 作业集成中关联的移动应用作业 的权限
        if(CollectionUtils.isNotEmpty(allBenchSystemIdList)){
            //组件中的数据源
            HashSet<Long> customIdSet=new HashSet<>(allBenchSystemIdList);
            List<LabelSystemData> systemDataList= labelSystemDataMapper.queryBySystemIdList(customIdSet);
            //过滤【鼎捷雅典娜APP】的作业权限，返回没有权限的组件ID
            UserAuthSystemLabelVo authSystemLabelVo = mobileUserAuthService.buildSystemIdApp(systemDataList);
            //将有权限的【鼎捷雅典娜APP】作业加入
            if(null !=authSystemLabelVo && CollectionUtils.isNotEmpty(authSystemLabelVo.getPermSystemIdList())){
                customIdList.addAll(authSystemLabelVo.getPermSystemIdList());
            }

        }

        List<JobBench> jobUserBenchList = new ArrayList<>();
        //去掉没有作业的工作台或者泳道
        for (JobBench jobBench : jobBenchList) {
            //泳道为空，则不返回
            if (CollectionUtils.isEmpty(jobBench.getLaneList())) {
                continue;
            }
            List<Long> laneSystemIdList = getAllSystemId(jobBench);
            //工作台下所有组件都没有权限
            Boolean isPermissionAll = CollectionUtils.containsAny(laneSystemIdList, customIdList);
            if (!isPermissionAll) {
                continue;
            }

            // 如果工作台全是业务待办组件，则需要判断是否隐藏
            boolean flag = laneSystemIdList.stream().allMatch(x -> businessTodoIdList.contains(x));
            if (flag) {
                jobBench.setNeedDetermineHidden(Boolean.TRUE);
            }

            List<JobBench> laneList = new ArrayList<>();
            for (JobBench lean : jobBench.getLaneList()) {
                //泳道下组件
                List<Long> ngSystemIdList = lean.getJobList().stream().map(JobBenchCustom::getSystemId).collect(Collectors.toList());
                //判断该泳道下是否存在业务代办组件
                boolean isToDoSystemId = ngSystemIdList.stream().anyMatch(businessTodoIdList::contains);
                for (JobBenchCustom job : lean.getJobList()) {
                    job.setIsPermission(false);
                    //权限内的，说明有该作业的操作权限
                    if (customIdList.contains(job.getSystemId())) {
                        job.setIsPermission(true);
                    }
                    //该泳道下面有业务代办组件、且 当前的组件为非业务代办组件 且 当前的组件没有权限,则需要判断是否隐藏工作台
                    if (isToDoSystemId && !businessTodoIdList.contains(job.getSystemId()) && !job.getIsPermission()) {
                        jobBench.setNeedDetermineHidden(Boolean.TRUE);
                    }
                    //该泳道下面有业务代办组件、且 当前的组件为非业务代办组件 且 当前的组件有权限,则不需要判断是否隐藏工作台
                    if (isToDoSystemId && !businessTodoIdList.contains(job.getSystemId()) && job.getIsPermission()) {
                        jobBench.setNeedDetermineHidden(Boolean.FALSE);
                    }
                    // 业务待办组件的类型
                    if (businessTodoIdList.contains(job.getSystemId())) {
                        job.setLabelDataCategory(Constants.DataCategoryEnum.BUSINESS_TODO.getVal());
                    }
                }
                laneList.add(lean);
            }
            jobBench.setLaneList(laneList);
            jobUserBenchList.add(jobBench);
        }
        return jobUserBenchList;
    }


    /**
     * 获取工作台下所有组件id
     *
     * @param jobBench
     * @return
     */
    public List<Long> getAllSystemId(JobBench jobBench) {
        List<Long> systemIdList = new ArrayList<>();
        for (JobBench lean : jobBench.getLaneList()) {
            if (CollectionUtils.isNotEmpty(lean.getJobList())) {
                List<Long> systemIds = lean.getJobList().stream().map(JobBenchCustom::getSystemId).collect(Collectors.toList());
                systemIdList.addAll(systemIds);
            }
        }
        return systemIdList;
    }

    /**
     * 循环查询泳道和组件信息
     *
     * @param jobBench
     */
    public void getBenchChild(JobBench jobBench, List<Long> systemIdList,List<Long> allSystemIdList) {
        JobBench req = new JobBench();
        //查询下级信息
        req.setParentId(jobBench.getId());
        List<JobBench> jobBenchList = getBenchList(req);
        //查询作业
        if (CollectionUtils.isEmpty(jobBenchList)) {
            //查询是否有作业关联
            List<JobBenchCustom> jobBenchCustomList = jobBenchCustomMapper.selectBenchJob(systemIdList, jobBench.getId());
            if(CollectionUtils.isNotEmpty(jobBenchCustomList)){
                List<Long> systemIds=jobBenchCustomList.stream().map(JobBenchCustom::getSystemId).collect(Collectors.toList());
                allSystemIdList.addAll(systemIds);
            }
            jobBench.setJobList(jobBenchCustomList);
        }//循环查询下级
        else {
            jobBench.setLaneList(jobBenchList);
            for (JobBench jobBenchChild : jobBenchList) {
                getBenchChild(jobBenchChild, systemIdList,allSystemIdList);
            }
        }
    }

    /**
     * 给组件名称翻译
     *
     * @param jobBenchCustomList
     */
    public void transJobName(List<JobBenchCustom> jobBenchCustomList) {
        for (JobBenchCustom jobBenchCustom : jobBenchCustomList) {
            String name = translateService.translateTextCache(jobBenchCustom.getNameZh(), StringUtils.EMPTY);
            jobBenchCustom.setNameZh(name);
        }
    }


    @Override
    @Transactional
    public Long saveBench(JobBench jobBench) {
        if (null != jobBench.getId()) {
            jobBenchMapper.updateById(jobBench);
        } else {
            jobBench.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            jobBenchMapper.insert(jobBench);
        }
        return jobBench.getId();
    }

    @Override
    public List<JobBench> selectByName(JobBench req) {
        QueryWrapper queryWrapper = new QueryWrapper<JobBench>();
        queryWrapper.orderByAsc("label_index");
        //名称查询
        if (StringUtils.isNotEmpty(req.getName())) {
            queryWrapper.eq("name", req.getName());
        }
        if (null != req.getId()) {
            queryWrapper.notIn("id", req.getId());
        }
        if (null != req.getParentId()) {
            queryWrapper.eq("parent_id", req.getParentId());
        }
        return jobBenchMapper.selectList(queryWrapper);
    }

    @Override
    @Transactional
    public Integer saveJobList(JobBenchSaveVO saveVO) {
        QueryWrapper queryWrapper = new QueryWrapper<JobBenchCustom>();
        //泳道查询
        if (null != saveVO.getBenchId()) {
            queryWrapper.eq("bench_id", saveVO.getBenchId());
        }
        jobBenchCustomMapper.delete(queryWrapper);
        if (CollectionUtils.isEmpty(saveVO.getSystemIdList())) {
            return null;
        }
        return jobBenchCustomMapper.insertBatch(packageBenchCustom(saveVO));
    }

    @Override
    public List<JobBenchCustom> selectBySystem(JobBenchSaveVO req) {
        QueryWrapper queryWrapper = new QueryWrapper<JobBenchCustom>();
        queryWrapper.orderByAsc("label_index");
        //泳道查询
        if (null != req.getBenchId()) {
            queryWrapper.eq("bench_id", req.getBenchId());
        }
        //组件查询
        if (CollectionUtils.isNotEmpty(req.getSystemIdList())) {
            queryWrapper.in("system_id", req.getSystemIdList());
        }
        return jobBenchCustomMapper.selectList(queryWrapper);
    }

    @Override
    @Transactional
    public Integer delLaneJob(JobBenchSaveVO saveVO) {

        QueryWrapper queryWrapper = new QueryWrapper<JobBenchCustom>();
        //泳道查询
        if (null != saveVO.getBenchId()) {
            queryWrapper.eq("bench_id", saveVO.getBenchId());
        }
        //组件id查询
        if (null != saveVO.getBenchId()) {
            queryWrapper.in("system_id", saveVO.getSystemIdList());
        }
        //多个泳道查询
        if (CollectionUtils.isNotEmpty(saveVO.getBenchIdList())) {
            queryWrapper.in("bench_id", saveVO.getBenchIdList());
        }
        return jobBenchCustomMapper.delete(queryWrapper);
    }

    @Override
    @Transactional
    public Integer delBeanLane(Long id) {
        //查询出作业下的泳道
        List<JobBench> jobBenchList = getJobBenchList(id);
        if (CollectionUtils.isEmpty(jobBenchList)) {
            return null;
        }
        List<Long> benchIdList = jobBenchList.stream().map(JobBench::getId).collect(Collectors.toList());
        //删除工作台、泳道
        jobBenchMapper.deleteBatchIds(benchIdList);
        //删除作业
        JobBenchSaveVO saveVO = new JobBenchSaveVO();
        saveVO.setBenchIdList(benchIdList);
        return delLaneJob(saveVO);
    }

    @Override
    @Transactional
    public Integer orderBenchLane(OrderBenchLaneVO req) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        //如果工作台id为空则表示给工作台排序，工作台的上级id为0，不为空时是按泳道排序
        if (null == req.getId()) {
            req.setId(0L);
        }
        //查询数据库工作台信息
        List<JobBench> jobBenchList = jobBenchMapper.selectBenchList(req.getBenchLaneList(), req.getId(), tenantId);
        //组装工作台或者泳道的位置顺序
        Map<Long, Integer> benchIndexMap = addBenchIndex(req.getBenchLaneList());
        //修改顺序
        for (JobBench jobBench : jobBenchList) {
            Integer labelIndex = benchIndexMap.get(jobBench.getId());
            if (null != labelIndex) {
                jobBench.setLabelIndex(labelIndex);
                jobBenchMapper.updateById(jobBench);
            }
        }
        return null;
    }

    @Override
    @Transactional
    public Integer orderLaneJob(OrderLaneJobVO req) {
        //泳道之间的组件切换，删除调整前泳道下组件
        if (null != req.getOldBenchId() && null != req.getOldSystemId()) {
            JobBenchSaveVO jobVO = new JobBenchSaveVO();
            jobVO.setBenchId(req.getOldBenchId());
            List<Long> systemIdList = new ArrayList<>();
            systemIdList.add(req.getOldSystemId());
            jobVO.setSystemIdList(systemIdList);
            delLaneJob(jobVO);
        }
        //更新调整后的泳道组件顺序
        JobBenchSaveVO saveVO = new JobBenchSaveVO();
        saveVO.setBenchId(req.getNowBenchId());
        saveVO.setSystemIdList(req.getNowSystemIdList());
        return saveJobList(saveVO);
    }

    /**
     * 组装工作台或者泳道的位置顺序
     *
     * @param benchLaneList 工作台或者泳道id
     * @return
     */
    public Map<Long, Integer> addBenchIndex(List<Long> benchLaneList) {
        Map<Long, Integer> benchIndexMap = new HashMap<>();
        int i = 0;
        for (Long benchLaneId : benchLaneList) {
            benchIndexMap.put(benchLaneId, i);
            i++;
        }
        return benchIndexMap;
    }

    /**
     * 获取工作台、泳道以及下面的自定义组件信息
     *
     * @param id 作业/泳道id
     * @return
     */
    public List<JobBench> getJobBenchList(Long id) {
        List<JobBench> jobBenchList = new ArrayList<>();
        JobBench jobBench = jobBenchMapper.selectById(id);
        if (null != jobBench) {
            jobBenchList.add(jobBench);
        }
        JobBench req = new JobBench();
        req.setParentId(id);
        List<JobBench> jobBenchChildList = selectByName(req);
        if (CollectionUtils.isNotEmpty(jobBenchChildList)) {
            jobBenchList.addAll(jobBenchChildList);
        }
        return jobBenchList;
    }

    /**
     * 组装泳道和组件的关系数据
     *
     * @param saveVO
     * @return
     */
    public List<JobBenchCustom> packageBenchCustom(JobBenchSaveVO saveVO) {
        List<JobBenchCustom> jobBenchCustoms = new ArrayList<>();
        int i = 0;
        for (Long systemId : saveVO.getSystemIdList()) {
            JobBenchCustom jobBenchCustom = new JobBenchCustom();
            jobBenchCustom.setBenchId(saveVO.getBenchId());
            jobBenchCustom.setSystemId(systemId);
            jobBenchCustom.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            jobBenchCustom.setLabelIndex(i);
            i++;
            jobBenchCustoms.add(jobBenchCustom);
        }
        return jobBenchCustoms;
    }


    @Override
    public List<JobBenchImportVo> readExcel(String fileId) {
        DMC dmcInstance = mdcService.buildDmc();
        List<JobBenchImportVo> excelVoList;
        try {
            byte[] byteArray = dmcInstance.download(fileId);
            ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
            SyncReadListener excelListener = new SyncReadListener();
            // 读取sheet
            ExcelReader excelReader = EasyExcelFactory.read(input).build();
            excelReader.read(EasyExcelFactory.readSheet(0).head(JobBenchImportVo.class).headRowNumber(2).registerReadListener(excelListener).build());
            // 这里千万别忘记关闭，读的
            excelReader.finish();
            excelVoList = mdcService.doReadSync(excelListener);
        } catch (Exception e) {
            log.error("JobBenchImport read excel occur error", e);
            throw new RuntimeException(e);
        }
        return excelVoList;
    }

    @Override
    @Transactional
    public ImportExcelResp importReport(List<JobBenchImportVo> jobBenchImportVoList) {
        ImportExcelResp excelResp = new ImportExcelResp();
        //自定义组件map,key:名称,val:自定义组件
        Map<String, LabelSystemCustom> systemCustomMap = new HashMap<>();
        //excel中工作台和泳道/作业信息map,key:工作台名称+工作台下泳道名称,val:作业名称
        Map<String, List<String>> jobNameMap = new HashMap<>();

        //excel中已经插入的工作台信息map,key:工作台名称,val:工作台ID
        Map<String, Long> benchNameIdMap = new HashMap<>();

        //excel中已经插入的泳道信息map,key:工作台名称+泳道名称,val:泳道ID
        Map<String, Long> laneIdMap = new HashMap<>();

        //查询自定义组件-作业 和自定义组件-应用 分类的自定义组件
        LabelSystemAllVo req = new LabelSystemAllVo();
        List<Integer> dataCategoryList = new ArrayList<>();
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        req.setDataCategoryList(dataCategoryList);
        List<LabelSystemCustom> systemCustomList = labelSystemCustomService.queryCustomList(req);
        if (CollectionUtils.isNotEmpty(systemCustomList)) {
            systemCustomMap = systemCustomList.stream().collect(Collectors.toMap(LabelSystemCustom::getNameZh, Function.identity(), (a, b) -> a));
        }
        List<String> benchNameList = new ArrayList<>();
        //工作台位置下标
        Integer benchIndex = 0;
        //查询工作台信息
        List<JobBench> jobBenchList = jobBenchMapper.selectBenchList(new ArrayList<Long>(), 0L, Utils.getTenantId());
        if (CollectionUtils.isNotEmpty(jobBenchList)) {
            benchIndex = jobBenchList.get(jobBenchList.size() - 1).getLabelIndex() + 1;
            benchNameList = jobBenchList.stream().map(JobBench::getName).collect(Collectors.toList());
        }
        int successNum = 0;
        int failNum = 0;
        //泳道位置下标
        Integer laneIndex = 0;
        //作业位置下标
        Integer jobIndex = 0;
        for (JobBenchImportVo jobBenchImportVo : jobBenchImportVoList) {
            // 基础校验
            StringBuilder errorSb = validateData(jobBenchImportVo, benchNameList, systemCustomMap, jobNameMap);
            if (StringUtils.isNotBlank(errorSb.toString())) {
                failNum++;
                jobBenchImportVo.setFailDesc(errorSb.substring(0, errorSb.length() - 1));
                continue;
            }
            List<String> jobNameList = jobNameMap.get(jobBenchImportVo.getBenchName() + "_" + jobBenchImportVo.getLaneName());
            if (CollectionUtils.isEmpty(jobNameList)) {
                jobNameList = new ArrayList<>();
            }
            jobNameList.add(jobBenchImportVo.getJobName());
            jobNameMap.put(jobBenchImportVo.getBenchName() + "_" + jobBenchImportVo.getLaneName(), jobNameList);
            jobBenchImportVo.setFailDesc(errorSb.toString());
            //插入作业工作台和泳道
            initJobBench(jobBenchImportVo, systemCustomMap, benchNameIdMap, benchIndex, laneIndex, jobIndex, laneIdMap);
            successNum++;
        }
        String nowTime = DateUtils.getNowTime(DateUtils.DATE_TIME_FORMATTER);
        String pathName = "作业工作台导入记录_" + nowTime + ".xlsx";
        //生成失败的excel文件
        ShareInfo shareInfo = importRecordService.uploadExcel(write(jobBenchImportVoList, pathName));
        //初始化导入记录
        initDataImport(shareInfo.getFileId(), successNum, failNum, nowTime);
        excelResp.setFailFileId(shareInfo.getFileId());
        excelResp.setFailFileName(shareInfo.getFileName());
        excelResp.setFailFileUrl(shareInfo.getUrl());
        // 构建返回信息
        String resultCode;
        if (successNum > 0 && failNum == 0) {
            resultCode = "2001";
        } else if (successNum > 0 && failNum > 0) {
            resultCode = "2002";
        } else if (successNum == 0 && failNum > 0) {
            resultCode = "2003";
        } else {
            resultCode = "2003";
        }
        excelResp.setResultCode(resultCode);
        excelResp.setFailCount(failNum);
        excelResp.setSuccessCount(successNum);
        return excelResp;
    }


    /**
     * 初始化作业工作台导入记录
     *
     * @param fileId
     * @param successCount
     * @param failCount
     * @return
     */
    public JobBenchImport initDataImport(String fileId, Integer successCount, Integer failCount, String nowTime) {
        JobBenchImport importRecord = new JobBenchImport();
        importRecord.setFileId(fileId);
        importRecord.setSuccessCount(successCount);
        importRecord.setFailCount(failCount);
        importRecord.setCreateUserName(Utils.getUserName());
        importRecord.setCreateUserId(Utils.getUserId());
        importRecord.setCreateTime(DateUtils.getDateFormat(nowTime, DateUtils.DATE_TIME_FORMATTER, DateUtils.DATE_TIME_NORMAL_FORMATTER));
        importRecord.setModifyTime(DateUtils.getDateFormat(nowTime, DateUtils.DATE_TIME_FORMATTER, DateUtils.DATE_TIME_NORMAL_FORMATTER));
        importRecord.setModifyUserId(Utils.getUserId());
        importRecord.setTenantId(Utils.getTenantId());
        jobBenchImportMapper.insert(importRecord);
        return importRecord;
    }

    /**
     * 写入excel文件
     *
     * @param list 报表数据
     * @return
     */
    public File write(List<JobBenchImportVo> list, String pathName) {
        File file = new File(pathName);
        EasyExcel.write(file, JobBenchImportVo.class)
                .registerWriteHandler(Utils.initHorizontalCell())
                .relativeHeadRowIndex(1).registerWriteHandler(new JobBenchWriteHandler()).sheet("作业工作台").doWrite(list);
        return file;
    }

    /**
     * 新增工作台、泳道、作业和泳道关系
     *
     * @param jobBenchImportVo excel 中工作台、泳道信息
     * @param systemCustomMap  数据库中租户下自定义组件信息map
     * @param benchNameIdMap   工作台名称和ID的关系map
     * @param benchIndex       工作台位置下标
     * @param laneIndex        泳道位置下标
     * @param jobIndex         作业组件位置下标
     * @param laneNameIdMap    泳道信息map
     */
    public void initJobBench(JobBenchImportVo jobBenchImportVo, Map<String, LabelSystemCustom> systemCustomMap,
                             Map<String, Long> benchNameIdMap, int benchIndex, int laneIndex, int jobIndex,
                             Map<String, Long> laneNameIdMap) {
        //先从map中获取工作台信息
        Long benchId = benchNameIdMap.get(jobBenchImportVo.getBenchName());
        //该工作台为空，则初始化工作台信息
        if (null == benchId) {
            JobBench jobBench = new JobBench();
            jobBench.setName(jobBenchImportVo.getBenchName());
            jobBench.setLabelIndex(benchIndex);
            jobBench.setParentId(0L);
            jobBench.setCreateUserId(Utils.getUserId());
            jobBench.setCreateTime(DateUtils.getNowTime(""));
            jobBench.setModifyTime(DateUtils.getNowTime(""));
            jobBench.setModifyUserId(Utils.getUserId());
            jobBench.setTenantId(Utils.getTenantId());
            jobBenchMapper.insert(jobBench);
            benchNameIdMap.put(jobBenchImportVo.getBenchName(), jobBench.getId());
            benchId = jobBench.getId();
            benchIndex = benchIndex + 1;
        }
        //新增泳道信息
        //先从map中获取泳道信息
        String laneKey = jobBenchImportVo.getBenchName() + jobBenchImportVo.getLaneName();
        Long laneId = laneNameIdMap.get(laneKey);
        //该泳道为空，则初始化泳道信息
        if (null == laneId) {
            JobBench lane = new JobBench();
            lane.setName(jobBenchImportVo.getLaneName());
            lane.setLabelIndex(laneIndex);
            lane.setParentId(benchId);
            lane.setCreateUserId(Utils.getUserId());
            lane.setCreateTime(DateUtils.getNowTime(""));
            lane.setModifyTime(DateUtils.getNowTime(""));
            lane.setModifyUserId(Utils.getUserId());
            lane.setTenantId(Utils.getTenantId());
            jobBenchMapper.insert(lane);
            laneNameIdMap.put(laneKey, lane.getId());
            laneId = lane.getId();
            laneIndex = laneIndex + 1;
        }
        //新增泳道和作业的关系
        JobBenchCustom jobBenchCustom = new JobBenchCustom();
        jobBenchCustom.setBenchId(laneId);
        jobBenchCustom.setCreateUserId(Utils.getUserId());
        jobBenchCustom.setCreateTime(DateUtils.getNowTime(""));
        jobBenchCustom.setTenantId(Utils.getTenantId());
        jobBenchCustom.setLabelIndex(jobIndex);
        LabelSystemCustom systemCustom = systemCustomMap.get(jobBenchImportVo.getJobName());
        if (null != systemCustom) {
            jobBenchCustom.setSystemId(systemCustom.getId());
            jobBenchCustomMapper.insert(jobBenchCustom);
            jobIndex = jobIndex + 1;
        }

    }


    /**
     * 校验excel数据
     *
     * @param jobBenchImportVo excel中的数据
     * @param benchNameList    数据库中的工作台名称
     * @param systemCustomMap  自定义组件map,key:名称,val:自定义组件
     * @param jobNameMap       工作台泳道信息
     * @return
     */
    private StringBuilder validateData(JobBenchImportVo jobBenchImportVo, List<String> benchNameList, Map<String, LabelSystemCustom> systemCustomMap, Map<String, List<String>> jobNameMap) {
        StringBuilder errorSb = new StringBuilder();
        //工作台名称校验
        if (StringUtils.isEmpty(jobBenchImportVo.getBenchName())) {
            errorSb.append("“工作台名称”未填写").append(",");
        }
        if (StringUtils.isNotEmpty(jobBenchImportVo.getBenchName()) && jobBenchImportVo.getBenchName().length() > 12) {
            errorSb.append("“工作台名称”内容超过最大长度限制").append(",");
        }
        if (benchNameList.contains(jobBenchImportVo.getBenchName())) {
            errorSb.append("“工作台名称”重名").append(",");
        }
        //泳道名称校验
        if (StringUtils.isEmpty(jobBenchImportVo.getLaneName())) {
            errorSb.append("“泳道名称”未填写").append(",");
        }
        if (StringUtils.isNotEmpty(jobBenchImportVo.getLaneName()) && jobBenchImportVo.getLaneName().length() > 12) {
            errorSb.append("“泳道名称”内容超过最大长度限制").append(",");
        }
        if (StringUtils.isNotEmpty(jobBenchImportVo.getBenchName()) && StringUtils.isNotEmpty(jobBenchImportVo.getLaneName())) {
            //校验作业是否重名
            List<String> jobNameList = jobNameMap.get(jobBenchImportVo.getBenchName() + "_" + jobBenchImportVo.getLaneName());
            if (CollectionUtils.isEmpty(jobNameList)) {
                jobNameList = new ArrayList<>();
            }
            //作业名称重名
            if (StringUtils.isNotEmpty(jobBenchImportVo.getJobName()) &&
                    jobNameList.contains(jobBenchImportVo.getJobName())) {
                errorSb.append("“作业名称”重名").append(",");
            }
        }
        //作业校验
        if (StringUtils.isEmpty(jobBenchImportVo.getJobName())) {
            errorSb.append("“作业名称”未填写").append(",");
        }
        //作业不存在
        if (StringUtils.isNotEmpty(jobBenchImportVo.getJobName()) &&
                null == systemCustomMap.get(jobBenchImportVo.getJobName())) {
            errorSb.append("“作业名称”值错误").append(",");
        }
        //作业未启用
        if (StringUtils.isNotEmpty(jobBenchImportVo.getJobName()) &&
                null != systemCustomMap.get(jobBenchImportVo.getJobName())) {
            LabelSystemCustom systemCustom = systemCustomMap.get(jobBenchImportVo.getJobName());
            //没有开启
            if (systemCustom.getValidStatus().equals(Constants.VALID_STATUS_UNUSABLE)) {
                errorSb.append("关联作业未启用").append(",");
            }
            //分类不是作业和应用
            if (!systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_WORK.getVal())
                    && !systemCustom.getDataCategory().equals(Constants.DataCategoryEnum.CATEGORY_APP.getVal())
            ) {
                errorSb.append("“作业名称”值错误").append(",");
            }
        }
        return errorSb;
    }


    @Override
    public PageInfoResp<JobBenchImport> queryImportRecord(QueryImportRecordReq queryImportRecordReq) {
        QueryWrapper<JobBenchImport> condition = new QueryWrapper<>();
        if (StringUtils.isBlank(queryImportRecordReq.getStartTime()) || StringUtils.isBlank(queryImportRecordReq.getEndTime())) {
            String currentDate = DateUtils.getNowTime(DateUtils.DATE_TIME_NORMAL_FORMATTER);
            condition.ge("create_time", DateUtils.addDate(currentDate, DateUtils.DATE_TIME_NORMAL_FORMATTER, -1, DateUtils.YEAR));
            condition.le("create_time", currentDate);
        } else {
            condition.ge("create_time", queryImportRecordReq.getStartTime());
            condition.le("create_time", queryImportRecordReq.getEndTime());
        }
        if (StringUtils.isNotEmpty(queryImportRecordReq.getUserIdName())) {
            condition.and(i -> i.like("create_user_name", queryImportRecordReq.getUserIdName()).or().like("create_user_id", queryImportRecordReq.getUserIdName()));
        }
        condition.orderByDesc("create_time");
        PageInfoResp<JobBenchImport> pageInfoResp = new PageInfoResp<>();
        Page<JobBenchImport> pageResult = jobBenchImportMapper.selectPage(new Page<>(queryImportRecordReq.getPageNum(), queryImportRecordReq.getPageSize()), condition);
        if (pageResult == null) {
            pageResult = new Page<>();
        }
        List<JobBenchImport> respList = new ArrayList<>();
        if (pageResult != null && CollectionUtils.isNotEmpty(pageResult.getRecords())) {
            // 拼接文件预览链接
            respList = pageResult.getRecords().stream().map(x -> {
                x.setFileUrl(envProperties.getDmcUri() + Constants.DMC_FILE_PREVIEW_PATH + x.getFileId().trim());
                return x;
            }).collect(Collectors.toList());
        }
        pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
        pageInfoResp.setPageNo(queryImportRecordReq.getPageNum());
        pageInfoResp.setPageSize(queryImportRecordReq.getPageSize());
        pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        pageInfoResp.setList(respList);
        return pageInfoResp;
    }

    @Override
    public List<JobBenchExportVo> exportReport() {
        List<JobBenchExportVo> jobBenchExportVoList = new ArrayList<>();
        //自定义组件map,key:名称,val:自定义组件
        Map<Long, LabelSystemCustom> systemCustomMap = new HashMap<>();
        //查询自定义组件-作业 和自定义组件-应用 分类的自定义组件
        LabelSystemAllVo req = new LabelSystemAllVo();
        List<Integer> dataCategoryList = new ArrayList<>();
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_APP.getVal());
        dataCategoryList.add(Constants.DataCategoryEnum.CATEGORY_WORK.getVal());
        req.setDataCategoryList(dataCategoryList);
        List<LabelSystemCustom> systemCustomList = labelSystemCustomService.queryCustomList(req);
        if (CollectionUtils.isNotEmpty(systemCustomList)) {
            systemCustomMap = systemCustomList.stream().collect(Collectors.toMap(LabelSystemCustom::getId, Function.identity(), (a, b) -> a));
        }
        //查询工作台信息
        JobBench reqBench = new JobBench();
        //查询所有一级工作台
        reqBench.setParentId(0L);
        List<JobBench> jobBenchList = getBenchList(reqBench);
        for (JobBench jobBench : jobBenchList) {
            //查询泳道信息
            JobBench reqLane = new JobBench();
            //查询下级信息
            reqLane.setParentId(jobBench.getId());
            List<JobBench> laneList = getBenchList(reqLane);
            if (CollectionUtils.isEmpty(laneList)) {
                //组装空的工作台
                jobBenchExportVoList.add(initJobBench(jobBench.getName(), ""));
                continue;
            }
            List<Long> laneIdList = laneList.stream().map(JobBench::getId).collect(Collectors.toList());
            List<JobBenchCustom> jobBenchCustomList = jobBenchCustomMapper.selectBenchBy(laneIdList);
            Map<Long, List<JobBenchCustom>> laneSystemMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(jobBenchCustomList)) {
                laneSystemMap = jobBenchCustomList.stream().collect(Collectors.groupingBy(JobBenchCustom::getBenchId));
            }
            for (JobBench lane : laneList) {
                JobBenchExportVo jobBenchExportVo = new JobBenchExportVo();
                jobBenchExportVo.setBenchName(jobBench.getName());
                jobBenchExportVo.setLaneName(lane.getName());
                List<JobBenchCustom> benchCustomList = laneSystemMap.get(lane.getId());
                //组装空的泳道
                if (CollectionUtils.isEmpty(benchCustomList)) {
                    jobBenchExportVoList.add(jobBenchExportVo);
                    continue;
                }
                for (JobBenchCustom benchCustom : benchCustomList) {
                    JobBenchExportVo jobExportVo = new JobBenchExportVo();
                    jobExportVo.setBenchName(jobBench.getName());
                    jobExportVo.setLaneName(lane.getName());
                    LabelSystemCustom systemCustom = systemCustomMap.get(benchCustom.getSystemId());
                    //组装泳道下的作业
                    if (null != systemCustom) {
                        jobExportVo.setJobName(systemCustom.getNameZh());
                        jobBenchExportVoList.add(jobExportVo);
                    }
                }

            }
        }
        return jobBenchExportVoList;
    }

    /**
     * 初始化导出的工作台信息
     *
     * @param benchName
     * @param laneName
     * @return
     */
    public JobBenchExportVo initJobBench(String benchName, String laneName) {
        JobBenchExportVo jobBenchExportVo = new JobBenchExportVo();
        if (StringUtils.isNotEmpty(benchName)) {
            jobBenchExportVo.setBenchName(benchName);
        }
        if (StringUtils.isNotEmpty(laneName)) {
            jobBenchExportVo.setLaneName(laneName);
        }
        return jobBenchExportVo;
    }

}