package com.digiwin.athena.semc.service.bench.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.dto.portal.JobSyncReq;
import com.digiwin.athena.semc.entity.bench.SyncJobHistory;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.mapper.bench.SyncJobHistoryMapper;
import com.digiwin.athena.semc.mapper.bench.SyncJobInfoMapper;
import com.digiwin.athena.semc.service.bench.SyncJobInfoService;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

import lombok.extern.slf4j.Slf4j;


@Slf4j
@Service
public class SyncJobInfoServiceImpl extends ServiceImpl<SyncJobInfoMapper, SyncJobInfo> implements SyncJobInfoService {

    @Autowired
    SyncJobInfoMapper syncJobInfoMapper;

    @Autowired
    SyncJobHistoryMapper syncJobHistoryMapper;


    @Override
    @Transactional
    public Integer jobSyncSave(JobSyncReq req) {

        //如果是全量的同步方式，则按先全量删除，再新增
        if (req.getSyncModel() == 0) {
            //新增或者编辑
            if (null == req.getSyncType() || !req.getSyncType().equals(Constants.syncTypeEnum.DEL.getFlag())) {
                //保存作业信息
                addJobInfo(req.getAppIdCode(), req.getAppId(), req.getJobList());
            }
        } else {
            //新增或者编辑
            if (null == req.getSyncType() || !req.getSyncType().equals(Constants.syncTypeEnum.DEL.getFlag())) {
                //增量新增作业信息
                addIncrementJob(req.getAppIdCode(), req.getAppId(), req.getJobList());
            }
            //删除
            if (null != req.getSyncType() && req.getSyncType().equals(Constants.syncTypeEnum.DEL.getFlag())) {
                delJobInfo(req.getAppId(), req.getJobList());
            }
        }
        //保存同步历史
        // jobSyncHistorySave(req, 0, "");
        return null;
    }

    @Override
    public Integer jobSyncHistorySave(JobSyncReq req, Integer syncStatus, String resp) {
        SyncJobHistory syncJobHistory = new SyncJobHistory();
        syncJobHistory.setAppId(req.getAppId());
        syncJobHistory.setRespJson(resp);
        String reqJson = JSON.toJSONString(req);
        if (reqJson.length() > 200) {
            reqJson = reqJson.substring(200);
        }
        syncJobHistory.setReqJson(reqJson);
        syncJobHistory.setSyncStatus(syncStatus);
        return syncJobHistoryMapper.insert(syncJobHistory);
    }

    @Override
    public List<SyncJobInfo> selectJobList(String appId, List<String> accountIdList) {
        QueryWrapper<SyncJobInfo> condition = new QueryWrapper<>();
        condition.orderByAsc("id");
        if (StringUtils.isNotEmpty(appId)) {
            condition.eq("app_id", appId);
        }
        if (CollectionUtils.isNotEmpty(accountIdList)) {
            condition.in("account_id", accountIdList);
        }
        return syncJobInfoMapper.selectList(condition);
    }

    @Override
    public List<String> getJobAppIdList(List<String> appIdList) {
        return syncJobInfoMapper.getJobAppIdList(appIdList);
    }

    /**
     * 增量新增作业信息
     */
    public void addIncrementJob(String appIdCode, String appId, List<SyncJobInfo> jobList) {
        //待删除的数据
        List<String> delJobCodeList = new ArrayList<>();
        //待插入的数据
        List<SyncJobInfo> insertJobList = new ArrayList<>();
        for (SyncJobInfo job : jobList) {
            job.setAppIdCode(appIdCode);
            job.setAppId(appId);
            if (StringUtils.isEmpty(job.getJobCode())) {
                continue;
            }
            delJobCodeList.add(job.getJobCode());
            insertJobList.add(job);
        }
        if (CollectionUtils.isNotEmpty(delJobCodeList)) {
            //先删除appid下的全量数据
            QueryWrapper<SyncJobInfo> condition = new QueryWrapper<>();
            condition.eq("app_id", appId);
            condition.in("job_code", delJobCodeList);
            syncJobInfoMapper.delete(condition);
        }
        if (CollectionUtils.isNotEmpty(insertJobList)) {
            //批量保存作业
            saveBatch(insertJobList);
        }

    }

    /**
     * 新增作业信息
     */
    public void addJobInfo(String appIdCode, String appId, List<SyncJobInfo> jobList) {
        List<SyncJobInfo> insertJobList = new ArrayList<>();
        List<String> accountIdList = new ArrayList<>();
        for (SyncJobInfo job : jobList) {
            job.setAppIdCode(appIdCode);
            job.setAppId(appId);
            if (StringUtils.isEmpty(job.getJobCode())) {
                continue;
            }
            insertJobList.add(job);
            accountIdList.add(job.getAccountId());
        }
        if (CollectionUtils.isNotEmpty(insertJobList)) {
            //先删除appid下的全量数据
            QueryWrapper<SyncJobInfo> condition = new QueryWrapper<>();
            condition.eq("app_id", appId);
            // 账套id不为空，则增加账套维度的条件
            if (CollectionUtils.isNotEmpty(accountIdList)) {
                condition.in("account_id", accountIdList);
            }
            syncJobInfoMapper.delete(condition);
            //批量保存作业
            saveBatch(insertJobList);
        }
    }

    /**
     * 查询作业信息
     */
    public QueryWrapper getCondition(String appId, SyncJobInfo job) {
        QueryWrapper<SyncJobInfo> condition = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(job.getVersion())) {
            condition.eq("version", job.getVersion());
        }
        if (StringUtils.isNotEmpty(job.getJobCode())) {
            condition.eq("job_code", job.getJobCode());
        }
        if (StringUtils.isNotEmpty(appId)) {
            condition.eq("app_id", appId);
        }
        return condition;
    }

    /**
     * 删除作业信息
     */
    public void delJobInfo(String appId, List<SyncJobInfo> jobList) {
        for (SyncJobInfo job : jobList) {
            QueryWrapper<SyncJobInfo> condition = getCondition(appId, job);
            syncJobInfoMapper.delete(condition);
        }
    }
}