package com.digiwin.athena.semc.service.bench.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.semc.common.Constants;
import com.digiwin.athena.semc.common.DigiSrvcode;
import com.digiwin.athena.semc.common.PageInfoResp;
import com.digiwin.athena.semc.common.enums.ApplicationTypeEnum;
import com.digiwin.athena.semc.common.enums.EAIServiceNameEnum;
import com.digiwin.athena.semc.dto.message.DeleteMessageConfigReq;
import com.digiwin.athena.semc.dto.message.QueryThirdMessageConfigReq;
import com.digiwin.athena.semc.dto.portal.JobSyncReq;
import com.digiwin.athena.semc.entity.bench.SyncJobInfo;
import com.digiwin.athena.semc.entity.bench.ThirdJobConfig;
import com.digiwin.athena.semc.entity.portal.PreinstalledApplication;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import com.digiwin.athena.semc.env.EnvProperties;
import com.digiwin.athena.semc.mapper.bench.ThirdJobConfigMapper;
import com.digiwin.athena.semc.proxy.esp.service.ESPService;
import com.digiwin.athena.semc.proxy.tripartite.service.TripartiteService;
import com.digiwin.athena.semc.service.bench.SyncJobInfoService;
import com.digiwin.athena.semc.service.bench.ThirdJobConfigService;
import com.digiwin.athena.semc.service.portal.IPreinstalledApplicationService;
import com.digiwin.athena.semc.service.sso.IErpSsoInfoService;
import com.digiwin.athena.semc.service.sso.IThirdSsoInfoService;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;


@Slf4j
@Service
public class ThirdJobConfigServiceImpl extends ServiceImpl<ThirdJobConfigMapper, ThirdJobConfig> implements ThirdJobConfigService {

    @Autowired
    ThirdJobConfigMapper thirdJobConfigMapper;

    @Resource
    private IPreinstalledApplicationService preinstalledApplicationService;

    @Autowired
    IErpSsoInfoService erpSsoInfoService;

    @Autowired
    IThirdSsoInfoService thirdSsoInfoService;

    @Resource
    private ESPService espService;

    @Resource
    EnvProperties envProperties;

    @Autowired
    TripartiteService tripartiteService;

    @Resource
    private SyncJobInfoService syncJobInfoService;


    @Override
    public Integer saveThirdJob(ThirdJobConfig req) {
        if (null == req.getId()) {
            thirdJobConfigMapper.insert(req);
        } else {
            thirdJobConfigMapper.updateById(req);
        }
        return null;
    }

    @Override
    public Integer delThirdJob(DeleteMessageConfigReq req) {
        return thirdJobConfigMapper.deleteBatchIds(req.getIdList());
    }

    @Override
    public PageInfoResp<ThirdJobConfig> queryConfigPage(QueryThirdMessageConfigReq req) {
        QueryWrapper<ThirdJobConfig> condition = new QueryWrapper<>();
        if (StringUtils.isNotBlank(req.getAppPrimaryId())) {
            condition.eq("app_primary_id", req.getAppPrimaryId());
        }
        if (req.getValidStatus() != null) {
            condition.eq("valid_status", req.getValidStatus());
        }
        if (req.getAppSource() != null) {
            condition.eq("app_source", req.getAppSource());
        }
        if (req.getDataGetType() != null) {
            condition.eq("data_get_type", req.getDataGetType());
        }
        condition.orderByDesc("modify_time");
        condition.eq("tenant_id", AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());

        // 查询
        PageInfoResp<ThirdJobConfig> pageInfoResp = new PageInfoResp<>();
        Page<ThirdJobConfig> pageResult = thirdJobConfigMapper.selectPage(new Page<>(req.getPageNum(), req.getPageSize()), condition);
        if (pageResult == null || CollectionUtils.isEmpty(pageResult.getRecords())) {
            return pageInfoResp;
        }

        // 获取应用名称
        List<ThirdJobConfig> jobConfigList = pageResult.getRecords();
        //组装应用名称
        packageAppCodeName(jobConfigList);
        pageInfoResp.setTotalPages(Integer.parseInt(String.valueOf(pageResult.getPages())));
        pageInfoResp.setPageNo(req.getPageNum());
        pageInfoResp.setPageSize(req.getPageSize());
        pageInfoResp.setTotalRecords(Integer.parseInt(String.valueOf(pageResult.getTotal())));
        pageInfoResp.setList(jobConfigList);
        return pageInfoResp;
    }

    @Override
    public boolean validJobConfigExist(ThirdJobConfig req) {
        QueryWrapper<ThirdJobConfig> condition = new QueryWrapper<>();
        condition.eq("app_source", req.getAppSource());
        condition.eq("app_primary_id", req.getAppPrimaryId());
        if (req.getId() != null) {
            condition.ne("id", req.getId());
        }
        ThirdJobConfig config = thirdJobConfigMapper.selectOne(condition);
        if (null != config) {
            return true;
        }
        return false;
    }

    /**
     * 组装应用名称
     *
     * @param jobConfigList 作业应用配置列表
     */
    public void packageAppCodeName(List<ThirdJobConfig> jobConfigList) {
        //根据源应用来源（ 0：CS、1：BS、2：平台预设、3：雅典娜应用）拆分数据
        //CS应用
        List<ThirdJobConfig> csList = jobConfigList.stream().filter(item -> ApplicationTypeEnum.CS_APPLICATION.getType().equals(item.getAppSource())).collect(Collectors.toList());
        List<String> csIdList = csList.stream().map(ThirdJobConfig::getAppPrimaryId).collect(Collectors.toList());
        Map<Long, ErpSsoInfo> erpInfoMap = erpSsoInfoService.getErpInfoMap(csIdList);
        //BS应用
        List<ThirdJobConfig> bsList = jobConfigList.stream().filter(item -> ApplicationTypeEnum.BS_APPLICATION.getType().equals(item.getAppSource())).collect(Collectors.toList());
        List<String> bsIdList = bsList.stream().map(ThirdJobConfig::getAppPrimaryId).collect(Collectors.toList());
        Map<Long, ThirdSsoInfo> thirdSsoInfoMap = thirdSsoInfoService.getSsoInfoMap(bsIdList);
        //预设应用
        Map<Long, PreinstalledApplication> preInfoMap = preinstalledApplicationService.getPreInfoMap();
        for (ThirdJobConfig jobConfig : jobConfigList) {
            String appName = "";
            //cs
            if (ApplicationTypeEnum.CS_APPLICATION.getType().equals(jobConfig.getAppSource())) {
                ErpSsoInfo erpSsoInfo = erpInfoMap.get(Long.parseLong(jobConfig.getAppPrimaryId()));
                if (null != erpSsoInfo) {
                    appName = erpSsoInfo.getName();
                }
            }
            //bs
            if (ApplicationTypeEnum.BS_APPLICATION.getType().equals(jobConfig.getAppSource())) {
                ThirdSsoInfo thirdSsoInfo = thirdSsoInfoMap.get(Long.parseLong(jobConfig.getAppPrimaryId()));
                if (thirdSsoInfo != null) {
                    appName = thirdSsoInfo.getAppName();
                }
            }
            //预设
            if (ApplicationTypeEnum.PRESET_APPLICATION.getType().equals(jobConfig.getAppSource())) {
                PreinstalledApplication preinstalledApplication = preInfoMap.get(Long.parseLong(jobConfig.getAppPrimaryId()));
                if (null != preinstalledApplication) {
                    appName = preinstalledApplication.getApplicationName();
                }
            }
            jobConfig.setAppName(appName);
        }
    }

    @Override
    public List<SyncJobInfo> getThirdJobList(String appPrimaryId, Integer appSource, String appToken, String appId, String appIdCode) {
        List<SyncJobInfo> jobInfoList = new ArrayList<>();
        QueryWrapper<ThirdJobConfig> condition = new QueryWrapper<>();
        condition.eq("app_source", appSource);
        condition.eq("app_primary_id", appPrimaryId);
        ThirdJobConfig config = thirdJobConfigMapper.selectOne(condition);
        //如果配置为空或者是同步的模式,数据获取方式 1:应用推送数据 2:拉取应用数据, 配置未启用
        if (null == config || null == config.getDataGetType()
                || config.getDataGetType().intValue() == 1
                ||  config.getValidStatus().equals(Constants.ValidStatusEnum.VALID_STATUS_ON.getVal())
        ) {
            return jobInfoList;
        }
        try {
            appToken = StringUtils.isBlank(appToken) ? envProperties.getAppToken() : appToken;
            //判断拉取模式，应用接入模式 0:混合云,通过ESP请求-地中台-三方系统接口
            if (null != config.getAppAccessModel() && config.getAppAccessModel().equals(Constants.DataModelEnum.MODEL_HYBRID_CLOUD.getVal())) {
                Map<String, String> extHeader = new HashMap<>();
                String token = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
                extHeader.put("digi-userToken", token);
                extHeader.put("digi-appToken", appToken);
                // 通过ESP查询三方系统的待办数据
                Map<String, Object> result = espService.queryByEsp(config.getMiddleSystemName(),
                        config.getMiddleSystemUid(), EAIServiceNameEnum.THIRD_JOB_QUERY.getServiceName(), extHeader, null, null,
                        null);
                // 没有显示字段时，返回异常
                if (Objects.isNull(result.get("jobList"))) {
                    return jobInfoList;
                }
                jobInfoList = JSONArray.parseArray(JSON.toJSONString(result.get("jobList")), SyncJobInfo.class);
            }
            //判断拉取模式，应用接入模式 1:非混合云,直接通过http接口请求三方系统接口
            if (null != config.getAppAccessModel() && config.getAppAccessModel().equals(Constants.DataModelEnum.MODEL_CLOUD.getVal())) {
                JSONArray jobData = tripartiteService.queryThirdData(config.getDomain() + Constants.QUERY_JOB_LIST_URL, appToken);
                if (null == jobData) {
                    return jobInfoList;
                }
                jobInfoList = JSONArray.parseArray(jobData.toJSONString(), SyncJobInfo.class);
            }
        } catch (Exception e) {
            log.error("拉取三方系统作业 异常,req:{},errorMsg:{}", JSON.toJSONString(config), e);
            return jobInfoList;
        }
        //将作业更新到数据库
        if (CollectionUtils.isNotEmpty(jobInfoList)) {
            JobSyncReq req = new JobSyncReq();
            req.setAppId(appId);
            req.setAppIdCode(appIdCode);
            req.setSyncType(0);
            req.setSyncModel(0);
            // 推送作业的维度是账套维度
            boolean accountFlag = req.getJobList().stream().anyMatch(x -> StringUtils.isNotBlank(x.getAccountId()));
            if (accountFlag) {
                List<SyncJobInfo> syncJobInfos = jobInfoList.stream().filter(item -> StringUtils.isNotBlank(item.getAccountId())).collect(Collectors.toList());
                Set<String> jobCodeList = new HashSet<>();
                List<SyncJobInfo> filterJobs = new ArrayList<>();
                for (SyncJobInfo syncJobInfo : syncJobInfos) {
                    String jobCode = syncJobInfo.getAccountId() + "-" + syncJobInfo.getJobCode();
                    if (jobCodeList.add(jobCode)) {
                        syncJobInfo.setJobCode(jobCode);
                        filterJobs.add(syncJobInfo);
                    }
                }
                req.setJobList(filterJobs);
            }else {
                req.setJobList(jobInfoList);
            }
            syncJobInfoService.jobSyncSave(req);
            return req.getJobList();
        }
        return Collections.emptyList();
    }

    @Override
    public ThirdJobConfig getJobConfigBy(String appCode, String appId) {
        return thirdJobConfigMapper.getJobConfigBy(appCode,appId);
    }

}