package com.digiwin.athena.semc.service.cache;

import com.digiwin.athena.semc.dto.config.MobilePortalCacheConfigParam;
import com.digiwin.athena.semc.dto.fineReport.FineReportConfigDTO;
import io.vavr.Tuple2;

import java.time.Duration;

/**
 * 通用配置服务
 */
public interface CommonConfigService {


    String getCommonConfig(String key);

    /**
     * 设置配置值（默认7天有效）
     */
    boolean setCommonConfig(String key, String value);

    boolean setCommonConfig(String key, String value, Duration duration);

    boolean removeCommonConfig(String key);


    /**
     * 获取移动端门户缓存配置参数
     *
     * @return
     */
    MobilePortalCacheConfigParam getMobilePortalCacheConfigParam();


    /**
     * 设置移动端门户缓存配置参数
     *
     * @param param
     * @return
     */
    boolean setMobilePortalCacheConfigParam(MobilePortalCacheConfigParam param);


    /**
     * 获取公告发布人是否可修改
     *
     * @return true可修改，false不可修改
     */
    boolean getNewsPublishEditFlag();


    /**
     * 获取iam用户权限缓存配置
     *
     * @return 是否开启缓存和缓存时间（秒）
     * {
     * "switch": true,
     * expire: 900
     * }
     */
    Tuple2<Boolean, Integer> getIamUserAuthInfoConfig();

    /**
     * 是否查询超管缓存 开关配置
     *
     * @return 是否开启缓存和缓存时间（小时）
     * {
     * "switch": true,
     * expire: 6小时
     * }
     */
    Tuple2<Boolean, Integer> querySuperAdminFlagSwitch();


    /**
     * 获取后台菜单是否可操作（添加或编辑）
     *
     * @return
     */
    boolean getBackendMenuOperateFlag();

    /**
     * 获取公告发送工作提醒人员数量
     *
     * @return 返回
     */
    Integer querySendNewsNoticeUserCount();

    /**
     * 获取公告是否给外部用户发送工作提醒 开关配置
     *
     * @return 返回
     */
    boolean querySendNewsNoticeOuterFlag();

    /**
     * 查询帆软应用参数配置
     *
     * @param tenantId 租户id
     * @return 返回
     */
    FineReportConfigDTO queryFineReportConfigCache(String tenantId);

    /**
     * 设置帆软应用参数配置
     *
     * @param fineReportConfigDTO 配置值
     * @param tenantId 租户id
     */
    void setFineReportConfigCache(FineReportConfigDTO fineReportConfigDTO, String tenantId);
}
