package com.digiwin.athena.semc.service.cache;

import java.time.Duration;

/**
 * redis使用规范：http://10.40.40.237:8080/microservice-elearning/#/handbook/redis-specification
 */
public interface ICacheService {

    Long incr(String key);

    boolean hasKey(String key);

    boolean hasKey(String serviceName, String functionName, String paraStr);

    void delete(String key);

    void deleteByPrex(String prex);

    void cache(String key, String value);

    void cache(String key, String value, Duration duration);

    void cache(String serviceName, String functionName, String paraStr, String value);

    void cache(String serviceName, String functionName, String paraStr, String value, Duration duration);

    Object get(String key);

    String getValue(String key);

    Object get(String serviceName, String functionName, String paraStr);

    void batchDelete(String pattern);

    void cacheNoPrefix(String key, String value);

}
