package com.digiwin.athena.semc.service.cache.impl;


import com.digiwin.athena.semc.service.cache.LockClient;

import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Service;

import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
@Service
public class RedissionLockImpl implements LockClient {

    private final String LOCK_KEY_PIREFIX = CacheServiceImpl.KEY_PREFIX +"lock:";

    private final RedissonClient redissonClient;

    @Override
    public RLock getLock(String lockKey) {
        return redissonClient.getLock(LOCK_KEY_PIREFIX+lockKey);
    }

    @Override
    public void unlock(RLock lock) {
        if (lock != null && lock.isLocked() && lock.isHeldByCurrentThread()) {
            lock.unlock();
        }
    }
}
