package com.digiwin.athena.semc.service.common;

import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;

@Slf4j
public abstract class AbstractStorageHandlerBase<E> extends Thread {

    // 业务数据消息队列
    ArrayBlockingQueue<E> queue;

    private List<E> tempList = new ArrayList<>();

    public AbstractStorageHandlerBase(ArrayBlockingQueue<E> queue) {
        this.queue = queue;
    }

    /**
     * @description: 批量处理队列数据 5分钟内没有新消息且队列未满1000
     * @param
     * @return
     * @author: sunyfa
     */
    @Override
    public void run() {
        long begin = 0L;

        while (true) {
            try {
                // 队列中有数据且tempList的容量未达到1000，可继续往tempList中放入队列数据
                if (queue.size() > 0 && tempList.size() < 1000) {
                    log.info("continue add to tempList", JsonUtils.objectToString(tempList));
                    for (; queue.size() > 0 && tempList.size() < 1000; ) {
                        tempList.add(queue.take());
                    }
                    begin = System.currentTimeMillis();
                }
                if (CollectionUtils.isNotEmpty(tempList)) {
                    long cur = System.currentTimeMillis();
                    // 队列数据大于等于1000条 或者 5分钟内没有新消息且队列未满1000 则做批量操作
                    if (tempList.size() >= 1000) {
                        log.info("reach 1000 records");
                        process(tempList);
                        tempList.clear();
                    } else if (begin != 0L && cur - begin > 300000) {
                        log.info("reach 5 min");
                        process(tempList);
                        tempList.clear();
                    }

                    Thread.sleep(1000);
                } else {
                    Thread.sleep(100);
                }
            } catch (Exception e) {
                log.error("AbstractStorageHandlerBase run cycle error", e);
                tempList.clear();
                Thread.currentThread().interrupt();
            }
        }
    }

    /**
     * @description: 各业务实现存储逻辑方法
     * @param
     * @return
     * @author: sunyfa
     */
    @Transactional
    public abstract void process(List<E> tempList);
}
