package com.digiwin.athena.semc.service.common;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.entity.common.BizObjAuthRel;
import com.digiwin.athena.semc.entity.portal.KnowledgeApplicationRef;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchForLinkReq;
import com.digiwin.athena.semc.vo.common.BizObjAuthRelBatchVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @description: 业务对象授权接口
 * @createDate: 2023/5/26 9:24
 * @author: sunyfa
 */
public interface IBizObjAuthRelService extends IService<BizObjAuthRel> {
    /**
     * @description: 新增/修改业务对象权限关系
     * @param
     * @return
     * @author: sunyfa
     */
    void addBizObjectAuthRel(BizObjAuthRelBatchVo bizObjAuthRelBatchVo, int bizObjectType);

    /**
     * 管理后台，保存应用的查看权限对象
     *
     * @param bizObjAuthRelBatchForLinkReq 请求入参
     */
    void saveBizObjectAuthRelForLinkApp(BizObjAuthRelBatchForLinkReq bizObjAuthRelBatchForLinkReq);

    /**
     * 获取友情链接展示的应用
     *
     * @param bizObjType 业务类型
     * @return
     */
    List<BizObjAuthRel> qryBizObjAuthRel(Integer bizObjType);

    /**
     * 查询应用关联的权限对象
     *
     * @param bizObjAuthRelList 应用id
     * @return 返回
     */
    List<BizObjAuthRel> queryAuthListByAppId(List<KnowledgeApplicationRef> bizObjAuthRelList);
}
