package com.digiwin.athena.semc.service.common;

import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.entity.common.BizObjCommonUse;
import com.digiwin.athena.semc.vo.common.BizObjCommonUseVo;

import java.util.List;

/**
 * @description: 业务常用
 * @createDate: 2023/9/15
 * @author: sungqz
 */
public interface IBizObjCommonUseService extends IService<BizObjCommonUse> {

    /**
     * 查询业务对象常用记录
     *
     * @param bizObjType 业务类型
     * @return
     */
    List<BizObjCommonUse> queryCommonUseList(Integer bizObjType);

    /**
     * 保存业务对象常用记录
     *
     * @param bizObjCommonUseVo 请求dto
     * @param bizObjectType 业务类型
     */
    void saveCommonUse(BizObjCommonUseVo bizObjCommonUseVo, int bizObjectType);
}
