package com.digiwin.athena.semc.service.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.digiwin.athena.semc.entity.common.Folder;
import com.digiwin.athena.semc.vo.common.FolderLevelVo;
import com.digiwin.athena.semc.vo.common.MoveFolderChildVo;
import com.digiwin.athena.semc.vo.common.MoveFolderVo;

import java.util.List;
import java.util.Map;

/**
 * @description: 树操作接口
 * @createDate: 2023/5/26 9:22
 * @author: sunyfa
 */
public interface IFolderService extends IService<Folder> {
    /**
     * @description: 新增/修改目录
     * @param
     * @return
     * @author: sunyfa
     */
    int addOrModFolder(Folder folder);

    /**
     * @description: 删除目录
     * @param
     * @return
     * @author: sunyfa
     */
    void delFolder(Long id, int foldType);

    /**
     * @description: 移动目录
     * @param
     * @return 
     * @author: sunyfa
     */
    void moveFolder(List<MoveFolderVo> moveFolderVoList, Map<Long, MoveFolderChildVo> childrenFolderMap);

    /**
     * @description: 报表树查询
     * @param
     * @return
     * @author: sunyfa
     */
    List<Folder> qryFolder(int folderType);

    /**
     * @description: 校验是否存在子目录
     * @param
     * @return 
     * @author: sunyfa
     */
    boolean isExistChild(Long parent, int folderType);

    /**
     * 根据目录id查询所有当前目录及父目录的层级
     *
     * @param type 业务类型
     * @param folderId 目录id
     * @return
     */
    List<FolderLevelVo> qryCurrentAndParentFolderList(int type, long folderId);

    boolean exists(Wrapper<Folder> queryWrapper);
}